/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.blockrestoration;

import com.hideandseek.blockrestoration.BrokenBlockRecord;
import com.hideandseek.blockrestoration.TileEntitySnapshot;
import com.hideandseek.blockrestoration.TileEntitySnapshotKt;
import com.hideandseek.blockrestoration.TileEntityType;
import com.hideandseek.config.BlockRestorationConfig;
import com.hideandseek.disguise.DisguiseManager;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.NoWhenBranchMatchedException;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\fJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u001a\u001a\u00020\u0019J\u0006\u0010\u001b\u001a\u00020\u0019J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u001d2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\fJ\u0006\u0010\u001f\u001a\u00020\u000fJ\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020!H\u0002J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\rH\u0002J\u0018\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/hideandseek/blockrestoration/BlockRestorationManager;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "config", "Lcom/hideandseek/config/BlockRestorationConfig;", "disguiseManager", "Lcom/hideandseek/disguise/DisguiseManager;", "<init>", "(Lorg/bukkit/plugin/Plugin;Lcom/hideandseek/config/BlockRestorationConfig;Lcom/hideandseek/disguise/DisguiseManager;)V", "trackedBlocks", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/bukkit/Location;", "Lcom/hideandseek/blockrestoration/BrokenBlockRecord;", "restorationTask", "Lorg/bukkit/scheduler/BukkitTask;", "trackBrokenBlock", "", "block", "Lorg/bukkit/block/Block;", "gameId", "", "restoreBlockNow", "location", "clearGameBlocks", "", "clearAll", "getTrackedBlockCount", "getGameBlocks", "", "isTracked", "start", "stop", "", "processRestorations", "performRestoration", "record", "restoreTileEntity", "blockState", "Lorg/bukkit/block/BlockState;", "snapshot", "Lcom/hideandseek/blockrestoration/TileEntitySnapshot;", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nBlockRestorationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockRestorationManager.kt\ncom/hideandseek/blockrestoration/BlockRestorationManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,271:1\n1#2:272\n774#3:273\n865#3,2:274\n*S KotlinDebug\n*F\n+ 1 BlockRestorationManager.kt\ncom/hideandseek/blockrestoration/BlockRestorationManager\n*L\n128#1:273\n128#1:274,2\n*E\n"})
public final class BlockRestorationManager {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final BlockRestorationConfig config;
    @NotNull
    private final DisguiseManager disguiseManager;
    @NotNull
    private final ConcurrentHashMap<Location, BrokenBlockRecord> trackedBlocks;
    @Nullable
    private BukkitTask restorationTask;

    public BlockRestorationManager(@NotNull Plugin plugin, @NotNull BlockRestorationConfig config, @NotNull DisguiseManager disguiseManager) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(disguiseManager, "disguiseManager");
        this.plugin = plugin;
        this.config = config;
        this.disguiseManager = disguiseManager;
        this.trackedBlocks = new ConcurrentHashMap();
    }

    public final boolean trackBrokenBlock(@NotNull Block block, @NotNull String gameId) {
        Intrinsics.checkNotNullParameter(block, "block");
        Intrinsics.checkNotNullParameter(gameId, "gameId");
        if (!(((CharSequence)gameId).length() > 0)) {
            boolean $i$a$-require-BlockRestorationManager$trackBrokenBlock$22 = false;
            String $i$a$-require-BlockRestorationManager$trackBrokenBlock$22 = "gameId must not be empty";
            throw new IllegalArgumentException($i$a$-require-BlockRestorationManager$trackBrokenBlock$22.toString());
        }
        Location location = block.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        if (this.disguiseManager.getDisguisedPlayerAt(location) != null) {
            return false;
        }
        Location location2 = block.getLocation().clone();
        Intrinsics.checkNotNullExpressionValue(location2, "clone(...)");
        Location location3 = location2;
        BlockData blockData = block.getBlockData().clone();
        Intrinsics.checkNotNullExpressionValue(blockData, "clone(...)");
        BlockData blockData2 = blockData;
        BlockState blockState = block.getState();
        Intrinsics.checkNotNullExpressionValue(blockState, "getState(...)");
        TileEntitySnapshot tileEntityData = TileEntitySnapshotKt.captureTileEntity(blockState);
        long currentTime = System.currentTimeMillis();
        long restoreTime = currentTime + this.config.getRestorationDelayMs();
        BrokenBlockRecord record = new BrokenBlockRecord(location3, blockData2, tileEntityData, currentTime, restoreTime, gameId);
        BrokenBlockRecord existingRecord = this.trackedBlocks.putIfAbsent(location3, record);
        return existingRecord == null;
    }

    public final boolean restoreBlockNow(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        if (!this.plugin.getServer().isPrimaryThread()) {
            boolean bl = false;
            String string = "restoreBlockNow must be called from main thread";
            throw new IllegalStateException(string.toString());
        }
        BrokenBlockRecord brokenBlockRecord = this.trackedBlocks.remove(location);
        if (brokenBlockRecord == null) {
            return false;
        }
        BrokenBlockRecord record = brokenBlockRecord;
        return this.performRestoration(record);
    }

    public final int clearGameBlocks(@NotNull String gameId) {
        Intrinsics.checkNotNullParameter(gameId, "gameId");
        if (!(((CharSequence)gameId).length() > 0)) {
            boolean $i$a$-require-BlockRestorationManager$clearGameBlocks$22 = false;
            String $i$a$-require-BlockRestorationManager$clearGameBlocks$22 = "gameId must not be empty";
            throw new IllegalArgumentException($i$a$-require-BlockRestorationManager$clearGameBlocks$22.toString());
        }
        int count = 0;
        Iterator<Map.Entry<Location, BrokenBlockRecord>> iterator2 = this.trackedBlocks.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Location, BrokenBlockRecord> entry;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (!Intrinsics.areEqual(entry.getValue().getGameId(), gameId)) continue;
            iterator2.remove();
            ++count;
        }
        return count;
    }

    public final int clearAll() {
        int count = this.trackedBlocks.size();
        this.trackedBlocks.clear();
        return count;
    }

    public final int getTrackedBlockCount() {
        return this.trackedBlocks.size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<BrokenBlockRecord> getGameBlocks(@NotNull String gameId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(gameId, "gameId");
        if (!(((CharSequence)gameId).length() > 0)) {
            boolean $i$a$-require-BlockRestorationManager$getGameBlocks$22 = false;
            String $i$a$-require-BlockRestorationManager$getGameBlocks$22 = "gameId must not be empty";
            throw new IllegalArgumentException($i$a$-require-BlockRestorationManager$getGameBlocks$22.toString());
        }
        Collection<BrokenBlockRecord> collection = this.trackedBlocks.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BrokenBlockRecord it = (BrokenBlockRecord)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getGameId(), gameId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isTracked(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return this.trackedBlocks.containsKey(location);
    }

    @NotNull
    public final BukkitTask start() {
        if (!(this.restorationTask == null)) {
            boolean bl = false;
            String string = "Restoration task is already running";
            throw new IllegalStateException(string.toString());
        }
        BukkitTask bukkitTask = this.restorationTask = this.plugin.getServer().getScheduler().runTaskTimer(this.plugin, () -> BlockRestorationManager.start$lambda$1(this), 1L, 1L);
        Intrinsics.checkNotNull(bukkitTask);
        return bukkitTask;
    }

    public final void stop() {
        BukkitTask bukkitTask = this.restorationTask;
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
        this.restorationTask = null;
    }

    private final void processRestorations() {
        long currentTime = System.currentTimeMillis();
        int restoredCount = 0;
        int maxPerTick = this.config.getMaxRestorationsPerTick();
        Iterator<Map.Entry<Location, BrokenBlockRecord>> iterator2 = this.trackedBlocks.entrySet().iterator();
        while (iterator2.hasNext() && restoredCount < maxPerTick) {
            BrokenBlockRecord record;
            Map.Entry<Location, BrokenBlockRecord> entry;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            Intrinsics.checkNotNullExpressionValue(entry.getValue(), "<get-value>(...)");
            if (!record.isReadyForRestoration(currentTime) || !record.getLocation().isChunkLoaded() || this.disguiseManager.getDisguisedPlayerAt(record.getLocation()) != null || !this.performRestoration(record)) continue;
            iterator2.remove();
            ++restoredCount;
            if (!this.config.getDebugLogging()) continue;
            this.plugin.getLogger().info("Restored block at " + record.getLocation() + " (game: " + record.getGameId() + ")");
        }
        if (this.config.getLogRestorationStats() && restoredCount > 0) {
            this.plugin.getLogger().info("Restored " + restoredCount + " blocks this tick (" + this.trackedBlocks.size() + " remaining)");
        }
    }

    private final boolean performRestoration(BrokenBlockRecord record) {
        boolean bl;
        try {
            Block block = record.getLocation().getBlock();
            Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
            Block block2 = block;
            block2.setBlockData(record.getBlockData(), false);
            if (record.getTileEntityData() != null && this.config.getEnableTileEntityRestoration()) {
                BlockState blockState = block2.getState();
                Intrinsics.checkNotNullExpressionValue(blockState, "getState(...)");
                this.restoreTileEntity(blockState, record.getTileEntityData());
            }
            bl = true;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to restore block at " + record.getLocation() + ": " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    private final void restoreTileEntity(BlockState blockState, TileEntitySnapshot snapshot) {
        try {
            switch (WhenMappings.$EnumSwitchMapping$0[snapshot.getTileEntityType().ordinal()]) {
                case 1: {
                    if (blockState instanceof Container) {
                        ItemStack[] contents;
                        Object object = snapshot.getData().get("inventory");
                        ItemStack[] itemStackArray = contents = object instanceof ItemStack[] ? (ItemStack[])object : null;
                        if (contents != null) {
                            ((Container)blockState).getInventory().setContents(contents);
                            blockState.update(true, false);
                        }
                    }
                    break;
                }
                case 2: {
                    if (blockState instanceof Sign) {
                        Object object = snapshot.getData().get("front_lines");
                        List frontLines = object instanceof List ? (List)object : null;
                        Object object2 = snapshot.getData().get("back_lines");
                        List backLines = object2 instanceof List ? (List)object2 : null;
                        blockState.update(true, false);
                    }
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to restore tile entity at " + blockState.getLocation() + ": " + e.getMessage());
        }
    }

    private static final void start$lambda$1(BlockRestorationManager this$0) {
        this$0.processRestorations();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TileEntityType.values().length];
            try {
                nArray[TileEntityType.CONTAINER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TileEntityType.SIGN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TileEntityType.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

