/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.blockrestoration;

import com.hideandseek.blockrestoration.TileEntitySnapshot;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import org.bukkit.Location;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\tJ\u000e\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tJ\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\t\u0010#\u001a\u00020\fH\u00c6\u0003JG\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010%\u001a\u00020\u001b2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006*"}, d2={"Lcom/hideandseek/blockrestoration/BrokenBlockRecord;", "", "location", "Lorg/bukkit/Location;", "blockData", "Lorg/bukkit/block/data/BlockData;", "tileEntityData", "Lcom/hideandseek/blockrestoration/TileEntitySnapshot;", "breakTimestamp", "", "restoreTimestamp", "gameId", "", "<init>", "(Lorg/bukkit/Location;Lorg/bukkit/block/data/BlockData;Lcom/hideandseek/blockrestoration/TileEntitySnapshot;JJLjava/lang/String;)V", "getLocation", "()Lorg/bukkit/Location;", "getBlockData", "()Lorg/bukkit/block/data/BlockData;", "getTileEntityData", "()Lcom/hideandseek/blockrestoration/TileEntitySnapshot;", "getBreakTimestamp", "()J", "getRestoreTimestamp", "getGameId", "()Ljava/lang/String;", "isReadyForRestoration", "", "currentTime", "getRemainingTime", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "EasyHideAndSeek"})
public final class BrokenBlockRecord {
    @NotNull
    private final Location location;
    @NotNull
    private final BlockData blockData;
    @Nullable
    private final TileEntitySnapshot tileEntityData;
    private final long breakTimestamp;
    private final long restoreTimestamp;
    @NotNull
    private final String gameId;

    public BrokenBlockRecord(@NotNull Location location, @NotNull BlockData blockData, @Nullable TileEntitySnapshot tileEntityData, long breakTimestamp, long restoreTimestamp, @NotNull String gameId) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(blockData, "blockData");
        Intrinsics.checkNotNullParameter(gameId, "gameId");
        this.location = location;
        this.blockData = blockData;
        this.tileEntityData = tileEntityData;
        this.breakTimestamp = breakTimestamp;
        this.restoreTimestamp = restoreTimestamp;
        this.gameId = gameId;
    }

    @NotNull
    public final Location getLocation() {
        return this.location;
    }

    @NotNull
    public final BlockData getBlockData() {
        return this.blockData;
    }

    @Nullable
    public final TileEntitySnapshot getTileEntityData() {
        return this.tileEntityData;
    }

    public final long getBreakTimestamp() {
        return this.breakTimestamp;
    }

    public final long getRestoreTimestamp() {
        return this.restoreTimestamp;
    }

    @NotNull
    public final String getGameId() {
        return this.gameId;
    }

    public final boolean isReadyForRestoration(long currentTime) {
        return currentTime >= this.restoreTimestamp;
    }

    public final long getRemainingTime(long currentTime) {
        long remaining = this.restoreTimestamp - currentTime;
        return remaining > 0L ? remaining : 0L;
    }

    @NotNull
    public final Location component1() {
        return this.location;
    }

    @NotNull
    public final BlockData component2() {
        return this.blockData;
    }

    @Nullable
    public final TileEntitySnapshot component3() {
        return this.tileEntityData;
    }

    public final long component4() {
        return this.breakTimestamp;
    }

    public final long component5() {
        return this.restoreTimestamp;
    }

    @NotNull
    public final String component6() {
        return this.gameId;
    }

    @NotNull
    public final BrokenBlockRecord copy(@NotNull Location location, @NotNull BlockData blockData, @Nullable TileEntitySnapshot tileEntityData, long breakTimestamp, long restoreTimestamp, @NotNull String gameId) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(blockData, "blockData");
        Intrinsics.checkNotNullParameter(gameId, "gameId");
        return new BrokenBlockRecord(location, blockData, tileEntityData, breakTimestamp, restoreTimestamp, gameId);
    }

    public static /* synthetic */ BrokenBlockRecord copy$default(BrokenBlockRecord brokenBlockRecord, Location location, BlockData blockData, TileEntitySnapshot tileEntitySnapshot, long l, long l2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            location = brokenBlockRecord.location;
        }
        if ((n & 2) != 0) {
            blockData = brokenBlockRecord.blockData;
        }
        if ((n & 4) != 0) {
            tileEntitySnapshot = brokenBlockRecord.tileEntityData;
        }
        if ((n & 8) != 0) {
            l = brokenBlockRecord.breakTimestamp;
        }
        if ((n & 0x10) != 0) {
            l2 = brokenBlockRecord.restoreTimestamp;
        }
        if ((n & 0x20) != 0) {
            string = brokenBlockRecord.gameId;
        }
        return brokenBlockRecord.copy(location, blockData, tileEntitySnapshot, l, l2, string);
    }

    @NotNull
    public String toString() {
        return "BrokenBlockRecord(location=" + this.location + ", blockData=" + this.blockData + ", tileEntityData=" + this.tileEntityData + ", breakTimestamp=" + this.breakTimestamp + ", restoreTimestamp=" + this.restoreTimestamp + ", gameId=" + this.gameId + ")";
    }

    public int hashCode() {
        int result = this.location.hashCode();
        result = result * 31 + this.blockData.hashCode();
        result = result * 31 + (this.tileEntityData == null ? 0 : this.tileEntityData.hashCode());
        result = result * 31 + Long.hashCode(this.breakTimestamp);
        result = result * 31 + Long.hashCode(this.restoreTimestamp);
        result = result * 31 + this.gameId.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BrokenBlockRecord)) {
            return false;
        }
        BrokenBlockRecord brokenBlockRecord = (BrokenBlockRecord)other;
        if (!Intrinsics.areEqual(this.location, brokenBlockRecord.location)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.blockData, brokenBlockRecord.blockData)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tileEntityData, brokenBlockRecord.tileEntityData)) {
            return false;
        }
        if (this.breakTimestamp != brokenBlockRecord.breakTimestamp) {
            return false;
        }
        if (this.restoreTimestamp != brokenBlockRecord.restoreTimestamp) {
            return false;
        }
        return Intrinsics.areEqual(this.gameId, brokenBlockRecord.gameId);
    }
}

