/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.blockrestoration;

import com.hideandseek.blockrestoration.TileEntitySnapshot;
import com.hideandseek.blockrestoration.TileEntityType;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.Pair;
import com.hideandseek.libs.kotlin.TuplesKt;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.collections.MapsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import java.util.List;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"captureTileEntity", "Lcom/hideandseek/blockrestoration/TileEntitySnapshot;", "blockState", "Lorg/bukkit/block/BlockState;", "EasyHideAndSeek"})
public final class TileEntitySnapshotKt {
    @Nullable
    public static final TileEntitySnapshot captureTileEntity(@NotNull BlockState blockState) {
        TileEntitySnapshot tileEntitySnapshot;
        Intrinsics.checkNotNullParameter(blockState, "blockState");
        BlockState blockState2 = blockState;
        if (blockState2 instanceof Container) {
            tileEntitySnapshot = new TileEntitySnapshot(TileEntityType.CONTAINER, MapsKt.mapOf(TuplesKt.to("inventory", ((Container)blockState).getInventory().getContents().clone())));
        } else if (blockState2 instanceof Sign) {
            List list = ((Sign)blockState).getSide(Side.FRONT).lines();
            Intrinsics.checkNotNullExpressionValue(list, "lines(...)");
            List frontLines = CollectionsKt.toList(list);
            List list2 = ((Sign)blockState).getSide(Side.BACK).lines();
            Intrinsics.checkNotNullExpressionValue(list2, "lines(...)");
            List backLines = CollectionsKt.toList(list2);
            Pair[] pairArray = new Pair[]{TuplesKt.to("front_lines", frontLines), TuplesKt.to("back_lines", backLines)};
            TileEntitySnapshot tileEntitySnapshot2 = new TileEntitySnapshot(TileEntityType.SIGN, MapsKt.mapOf(pairArray));
            tileEntitySnapshot = tileEntitySnapshot2;
        } else {
            tileEntitySnapshot = null;
        }
        return tileEntitySnapshot;
    }
}

