/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.config;

import com.hideandseek.arena.Arena;
import com.hideandseek.arena.ArenaBoundaries;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\bJ\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/hideandseek/config/ArenaConfig;", "", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "<init>", "(Lorg/bukkit/configuration/file/FileConfiguration;)V", "loadArenas", "", "", "Lcom/hideandseek/arena/Arena;", "saveArena", "", "arena", "deleteArena", "name", "deserializeArena", "section", "Lorg/bukkit/configuration/ConfigurationSection;", "serializeLocation", "path", "loc", "Lorg/bukkit/Location;", "deserializeLocation", "key", "world", "Lorg/bukkit/World;", "EasyHideAndSeek"})
public final class ArenaConfig {
    @NotNull
    private final FileConfiguration config;

    public ArenaConfig(@NotNull FileConfiguration config) {
        Intrinsics.checkNotNullParameter(config, "config");
        this.config = config;
    }

    @NotNull
    public final Map<String, Arena> loadArenas() {
        Map arenas = new LinkedHashMap();
        ConfigurationSection configurationSection = this.config.getConfigurationSection("arenas");
        if (configurationSection == null) {
            return arenas;
        }
        ConfigurationSection arenasSection = configurationSection;
        for (String key : arenasSection.getKeys(false)) {
            if (arenasSection.getConfigurationSection(key) == null) continue;
            try {
                ConfigurationSection arenaSection;
                Intrinsics.checkNotNull(key);
                Arena arena = this.deserializeArena(key, arenaSection);
                arenas.put(key, arena);
            }
            catch (Exception e) {
                System.out.println((Object)("Failed to load arena '" + key + "': " + e.getMessage()));
            }
        }
        return arenas;
    }

    public final void saveArena(@NotNull Arena arena) {
        Intrinsics.checkNotNullParameter(arena, "arena");
        String path = "arenas." + arena.getName();
        this.config.set(path + ".display-name", (Object)arena.getDisplayName());
        this.config.set(path + ".world", (Object)arena.getWorld().getName());
        this.serializeLocation(path + ".boundaries.pos1", arena.getBoundaries().getPos1());
        this.serializeLocation(path + ".boundaries.pos2", arena.getBoundaries().getPos2());
        Location center = arena.getBoundaries().getCenter();
        this.config.set(path + ".boundaries.center.x", (Object)center.getX());
        this.config.set(path + ".boundaries.center.y", (Object)center.getY());
        this.config.set(path + ".boundaries.center.z", (Object)center.getZ());
        this.config.set(path + ".boundaries.size", (Object)arena.getBoundaries().getSize());
    }

    public final void deleteArena(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.config.set("arenas." + name, null);
    }

    private final Arena deserializeArena(String name, ConfigurationSection section) {
        String string = section.getString("display-name");
        if (string == null) {
            string = name;
        }
        String displayName = string;
        String string2 = section.getString("world");
        if (string2 == null) {
            throw new IllegalArgumentException("Arena '" + name + "' missing world");
        }
        String worldName = string2;
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            throw new IllegalArgumentException("World '" + worldName + "' not found for arena '" + name + "'");
        }
        World world2 = world;
        ConfigurationSection configurationSection = section.getConfigurationSection("boundaries");
        if (configurationSection == null) {
            throw new IllegalArgumentException("Arena '" + name + "' missing boundaries");
        }
        ConfigurationSection boundariesSection = configurationSection;
        Location pos1 = this.deserializeLocation(boundariesSection, "pos1", world2);
        Location pos2 = this.deserializeLocation(boundariesSection, "pos2", world2);
        ArenaBoundaries boundaries = new ArenaBoundaries(pos1, pos2);
        return new Arena(name, displayName, world2, boundaries);
    }

    private final void serializeLocation(String path, Location loc) {
        this.config.set(path + ".x", (Object)loc.getX());
        this.config.set(path + ".y", (Object)loc.getY());
        this.config.set(path + ".z", (Object)loc.getZ());
    }

    private final Location deserializeLocation(ConfigurationSection section, String key, World world) {
        ConfigurationSection configurationSection = section.getConfigurationSection(key);
        if (configurationSection == null) {
            throw new IllegalArgumentException("Missing location section: " + key);
        }
        ConfigurationSection locSection = configurationSection;
        return new Location(world, locSection.getDouble("x"), locSection.getDouble("y"), locSection.getDouble("z"));
    }
}

