/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.effects;

import com.hideandseek.effects.EffectType;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.collections.MapsKt;
import com.hideandseek.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.ranges.RangesKt;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0014\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001b\b\u0086\b\u0018\u00002\u00020\u0001Be\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020&J\u0006\u0010*\u001a\u00020\rJ\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u000fJ \u0010#\u001a\u0004\u0018\u0001H-\"\u0006\b\u0000\u0010-\u0018\u00012\u0006\u0010.\u001a\u00020\bH\u0086\b\u00a2\u0006\u0002\u0010/J\u0006\u00100\u001a\u00020\bJ&\u00101\u001a\u0002H-\"\u0006\b\u0000\u0010-\u0018\u00012\u0006\u0010.\u001a\u00020\b2\u0006\u00102\u001a\u0002H-H\u0086\b\u00a2\u0006\u0002\u00103J\t\u00104\u001a\u00020\u0003H\u00c6\u0003J\t\u00105\u001a\u00020\u0003H\u00c6\u0003J\t\u00106\u001a\u00020\u0006H\u00c6\u0003J\t\u00107\u001a\u00020\bH\u00c6\u0003J\t\u00108\u001a\u00020\nH\u00c6\u0003J\t\u00109\u001a\u00020\nH\u00c6\u0003J\t\u0010:\u001a\u00020\rH\u00c6\u0003J\u0010\u0010;\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003\u00a2\u0006\u0002\u0010!J\u0015\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0011H\u00c6\u0003Jv\u0010=\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0011H\u00c6\u0001\u00a2\u0006\u0002\u0010>J\u0013\u0010?\u001a\u00020(2\b\u0010@\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010A\u001a\u00020\u000fH\u00d6\u0001J\t\u0010B\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001cR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\n\n\u0002\u0010\"\u001a\u0004\b \u0010!R\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006C"}, d2={"Lcom/hideandseek/effects/ActiveEffect;", "", "effectId", "Ljava/util/UUID;", "playerId", "effectType", "Lcom/hideandseek/effects/EffectType;", "gameId", "", "startTime", "Ljava/time/Instant;", "endTime", "intensity", "", "taskId", "", "metadata", "", "<init>", "(Ljava/util/UUID;Ljava/util/UUID;Lcom/hideandseek/effects/EffectType;Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;DLjava/lang/Integer;Ljava/util/Map;)V", "getEffectId", "()Ljava/util/UUID;", "getPlayerId", "getEffectType", "()Lcom/hideandseek/effects/EffectType;", "getGameId", "()Ljava/lang/String;", "getStartTime", "()Ljava/time/Instant;", "getEndTime", "getIntensity", "()D", "getTaskId", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getMetadata", "()Ljava/util/Map;", "getRemainingSeconds", "", "isExpired", "", "getTotalDuration", "getProgress", "withTaskId", "newTaskId", "T", "key", "(Ljava/lang/String;)Ljava/lang/Object;", "formatRemainingTime", "getMetadataOrDefault", "default", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/util/UUID;Ljava/util/UUID;Lcom/hideandseek/effects/EffectType;Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;DLjava/lang/Integer;Ljava/util/Map;)Lcom/hideandseek/effects/ActiveEffect;", "equals", "other", "hashCode", "toString", "EasyHideAndSeek"})
public final class ActiveEffect {
    @NotNull
    private final UUID effectId;
    @NotNull
    private final UUID playerId;
    @NotNull
    private final EffectType effectType;
    @NotNull
    private final String gameId;
    @NotNull
    private final Instant startTime;
    @NotNull
    private final Instant endTime;
    private final double intensity;
    @Nullable
    private final Integer taskId;
    @NotNull
    private final Map<String, Object> metadata;

    public ActiveEffect(@NotNull UUID effectId, @NotNull UUID playerId, @NotNull EffectType effectType, @NotNull String gameId, @NotNull Instant startTime, @NotNull Instant endTime, double intensity, @Nullable Integer taskId, @NotNull Map<String, ? extends Object> metadata) {
        Intrinsics.checkNotNullParameter(effectId, "effectId");
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter((Object)effectType, "effectType");
        Intrinsics.checkNotNullParameter(gameId, "gameId");
        Intrinsics.checkNotNullParameter(startTime, "startTime");
        Intrinsics.checkNotNullParameter(endTime, "endTime");
        Intrinsics.checkNotNullParameter(metadata, "metadata");
        this.effectId = effectId;
        this.playerId = playerId;
        this.effectType = effectType;
        this.gameId = gameId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.intensity = intensity;
        this.taskId = taskId;
        this.metadata = metadata;
    }

    public /* synthetic */ ActiveEffect(UUID uUID, UUID uUID2, EffectType effectType, String string, Instant instant, Instant instant2, double d, Integer n, Map map, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            UUID uUID3 = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue(uUID3, "randomUUID(...)");
            uUID = uUID3;
        }
        if ((n2 & 0x40) != 0) {
            d = 1.0;
        }
        if ((n2 & 0x80) != 0) {
            n = null;
        }
        if ((n2 & 0x100) != 0) {
            map = MapsKt.emptyMap();
        }
        this(uUID, uUID2, effectType, string, instant, instant2, d, n, map);
    }

    @NotNull
    public final UUID getEffectId() {
        return this.effectId;
    }

    @NotNull
    public final UUID getPlayerId() {
        return this.playerId;
    }

    @NotNull
    public final EffectType getEffectType() {
        return this.effectType;
    }

    @NotNull
    public final String getGameId() {
        return this.gameId;
    }

    @NotNull
    public final Instant getStartTime() {
        return this.startTime;
    }

    @NotNull
    public final Instant getEndTime() {
        return this.endTime;
    }

    public final double getIntensity() {
        return this.intensity;
    }

    @Nullable
    public final Integer getTaskId() {
        return this.taskId;
    }

    @NotNull
    public final Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public final long getRemainingSeconds() {
        Instant now = Instant.now();
        if (now.isAfter(this.endTime)) {
            return 0L;
        }
        return Duration.between(now, this.endTime).getSeconds();
    }

    public final boolean isExpired() {
        return Instant.now().isAfter(this.endTime);
    }

    public final long getTotalDuration() {
        return Duration.between(this.startTime, this.endTime).getSeconds();
    }

    public final double getProgress() {
        long total = this.getTotalDuration();
        if (total == 0L) {
            return 1.0;
        }
        long elapsed = Duration.between(this.startTime, Instant.now()).getSeconds();
        return RangesKt.coerceIn((double)elapsed / (double)total, 0.0, 1.0);
    }

    @NotNull
    public final ActiveEffect withTaskId(int newTaskId) {
        return ActiveEffect.copy$default(this, null, null, null, null, null, null, 0.0, newTaskId, null, 383, null);
    }

    public final /* synthetic */ <T> T getMetadata(String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        boolean $i$f$getMetadata = false;
        Object object = this.getMetadata().get(key);
        Intrinsics.reifiedOperationMarker(2, "T");
        return (T)object;
    }

    @NotNull
    public final String formatRemainingTime() {
        long seconds = this.getRemainingSeconds();
        long minutes = seconds / (long)60;
        long secs = seconds % (long)60;
        String string = "%02d:%02d";
        Object[] objectArray = new Object[]{minutes, secs};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    public final /* synthetic */ <T> T getMetadataOrDefault(String key, T t) {
        Intrinsics.checkNotNullParameter(key, "key");
        boolean $i$f$getMetadataOrDefault = false;
        Object object = this.getMetadata().get(key);
        Intrinsics.reifiedOperationMarker(2, "T");
        Object object2 = object;
        if (object == null) {
            object2 = t;
        }
        return (T)object2;
    }

    @NotNull
    public final UUID component1() {
        return this.effectId;
    }

    @NotNull
    public final UUID component2() {
        return this.playerId;
    }

    @NotNull
    public final EffectType component3() {
        return this.effectType;
    }

    @NotNull
    public final String component4() {
        return this.gameId;
    }

    @NotNull
    public final Instant component5() {
        return this.startTime;
    }

    @NotNull
    public final Instant component6() {
        return this.endTime;
    }

    public final double component7() {
        return this.intensity;
    }

    @Nullable
    public final Integer component8() {
        return this.taskId;
    }

    @NotNull
    public final Map<String, Object> component9() {
        return this.metadata;
    }

    @NotNull
    public final ActiveEffect copy(@NotNull UUID effectId, @NotNull UUID playerId, @NotNull EffectType effectType, @NotNull String gameId, @NotNull Instant startTime, @NotNull Instant endTime, double intensity, @Nullable Integer taskId, @NotNull Map<String, ? extends Object> metadata) {
        Intrinsics.checkNotNullParameter(effectId, "effectId");
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter((Object)effectType, "effectType");
        Intrinsics.checkNotNullParameter(gameId, "gameId");
        Intrinsics.checkNotNullParameter(startTime, "startTime");
        Intrinsics.checkNotNullParameter(endTime, "endTime");
        Intrinsics.checkNotNullParameter(metadata, "metadata");
        return new ActiveEffect(effectId, playerId, effectType, gameId, startTime, endTime, intensity, taskId, metadata);
    }

    public static /* synthetic */ ActiveEffect copy$default(ActiveEffect activeEffect, UUID uUID, UUID uUID2, EffectType effectType, String string, Instant instant, Instant instant2, double d, Integer n, Map map, int n2, Object object) {
        if ((n2 & 1) != 0) {
            uUID = activeEffect.effectId;
        }
        if ((n2 & 2) != 0) {
            uUID2 = activeEffect.playerId;
        }
        if ((n2 & 4) != 0) {
            effectType = activeEffect.effectType;
        }
        if ((n2 & 8) != 0) {
            string = activeEffect.gameId;
        }
        if ((n2 & 0x10) != 0) {
            instant = activeEffect.startTime;
        }
        if ((n2 & 0x20) != 0) {
            instant2 = activeEffect.endTime;
        }
        if ((n2 & 0x40) != 0) {
            d = activeEffect.intensity;
        }
        if ((n2 & 0x80) != 0) {
            n = activeEffect.taskId;
        }
        if ((n2 & 0x100) != 0) {
            map = activeEffect.metadata;
        }
        return activeEffect.copy(uUID, uUID2, effectType, string, instant, instant2, d, n, map);
    }

    @NotNull
    public String toString() {
        return "ActiveEffect(effectId=" + this.effectId + ", playerId=" + this.playerId + ", effectType=" + this.effectType + ", gameId=" + this.gameId + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", intensity=" + this.intensity + ", taskId=" + this.taskId + ", metadata=" + this.metadata + ")";
    }

    public int hashCode() {
        int result = this.effectId.hashCode();
        result = result * 31 + this.playerId.hashCode();
        result = result * 31 + this.effectType.hashCode();
        result = result * 31 + this.gameId.hashCode();
        result = result * 31 + this.startTime.hashCode();
        result = result * 31 + this.endTime.hashCode();
        result = result * 31 + Double.hashCode(this.intensity);
        result = result * 31 + (this.taskId == null ? 0 : ((Object)this.taskId).hashCode());
        result = result * 31 + ((Object)this.metadata).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ActiveEffect)) {
            return false;
        }
        ActiveEffect activeEffect = (ActiveEffect)other;
        if (!Intrinsics.areEqual(this.effectId, activeEffect.effectId)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.playerId, activeEffect.playerId)) {
            return false;
        }
        if (this.effectType != activeEffect.effectType) {
            return false;
        }
        if (!Intrinsics.areEqual(this.gameId, activeEffect.gameId)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.startTime, activeEffect.startTime)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.endTime, activeEffect.endTime)) {
            return false;
        }
        if (Double.compare(this.intensity, activeEffect.intensity) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual(this.taskId, activeEffect.taskId)) {
            return false;
        }
        return Intrinsics.areEqual(this.metadata, activeEffect.metadata);
    }
}

