/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.effects;

import com.hideandseek.effects.ActiveEffect;
import com.hideandseek.effects.EffectHandler;
import com.hideandseek.effects.EffectManager;
import com.hideandseek.effects.EffectStorage;
import com.hideandseek.effects.EffectType;
import com.hideandseek.effects.EffectValidator;
import com.hideandseek.effects.OverlapPolicy;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.NoWhenBranchMatchedException;
import com.hideandseek.libs.kotlin.TuplesKt;
import com.hideandseek.libs.kotlin.Unit;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.collections.MapsKt;
import com.hideandseek.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.libs.kotlin.ranges.RangesKt;
import com.hideandseek.utils.EffectScheduler;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000fJD\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0016JL\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010)\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u001a\u0010*\u001a\u0004\u0018\u00010$2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0018\u0010+\u001a\u00020,2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000e0.2\u0006\u0010&\u001a\u00020'H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020$002\u0006\u0010&\u001a\u00020'H\u0016J\b\u00101\u001a\u00020\u0019H\u0016J\b\u00102\u001a\u00020\u0011H\u0016J\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/hideandseek/effects/EffectManagerImpl;", "Lcom/hideandseek/effects/EffectManager;", "plugin", "Lorg/bukkit/plugin/Plugin;", "storage", "Lcom/hideandseek/effects/EffectStorage;", "scheduler", "Lcom/hideandseek/utils/EffectScheduler;", "logger", "Ljava/util/logging/Logger;", "<init>", "(Lorg/bukkit/plugin/Plugin;Lcom/hideandseek/effects/EffectStorage;Lcom/hideandseek/utils/EffectScheduler;Ljava/util/logging/Logger;)V", "effectHandlers", "", "Lcom/hideandseek/effects/EffectType;", "Lcom/hideandseek/effects/EffectHandler;", "registerHandler", "", "effectType", "handler", "applyEffect", "", "player", "Lorg/bukkit/entity/Player;", "durationSeconds", "", "intensity", "", "overlapPolicy", "Lcom/hideandseek/effects/OverlapPolicy;", "metadata", "", "", "", "handleOverlap", "existingEffect", "Lcom/hideandseek/effects/ActiveEffect;", "removeEffect", "playerId", "Ljava/util/UUID;", "removeAllEffects", "hasEffect", "getActiveEffect", "getRemainingTime", "", "getActiveEffectTypes", "", "getActiveEffects", "", "cleanupExpired", "clearAll", "getStats", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nEffectManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EffectManagerImpl.kt\ncom/hideandseek/effects/EffectManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,267:1\n1#2:268\n1869#3,2:269\n774#3:278\n865#3,2:279\n1869#3,2:281\n504#4,7:271\n*S KotlinDebug\n*F\n+ 1 EffectManagerImpl.kt\ncom/hideandseek/effects/EffectManagerImpl\n*L\n178#1:269,2\n216#1:278\n216#1:279,2\n230#1:281,2\n209#1:271,7\n*E\n"})
public final class EffectManagerImpl
implements EffectManager {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final EffectStorage storage;
    @NotNull
    private final EffectScheduler scheduler;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<EffectType, EffectHandler> effectHandlers;

    public EffectManagerImpl(@NotNull Plugin plugin, @NotNull EffectStorage storage, @NotNull EffectScheduler scheduler, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(storage, "storage");
        Intrinsics.checkNotNullParameter(scheduler, "scheduler");
        Intrinsics.checkNotNullParameter(logger, "logger");
        this.plugin = plugin;
        this.storage = storage;
        this.scheduler = scheduler;
        this.logger = logger;
        this.effectHandlers = new LinkedHashMap();
    }

    public /* synthetic */ EffectManagerImpl(Plugin plugin, EffectStorage effectStorage, EffectScheduler effectScheduler, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            Logger logger2 = plugin.getLogger();
            Intrinsics.checkNotNullExpressionValue(logger2, "getLogger(...)");
            logger = logger2;
        }
        this(plugin, effectStorage, effectScheduler, logger);
    }

    public final void registerHandler(@NotNull EffectType effectType, @NotNull EffectHandler handler) {
        Intrinsics.checkNotNullParameter((Object)effectType, "effectType");
        Intrinsics.checkNotNullParameter(handler, "handler");
        this.effectHandlers.put(effectType, handler);
    }

    @Override
    public boolean applyEffect(@NotNull Player player, @NotNull EffectType effectType, int durationSeconds, double intensity, @NotNull OverlapPolicy overlapPolicy, @NotNull Map<String, ? extends Object> metadata) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter((Object)effectType, "effectType");
        Intrinsics.checkNotNullParameter((Object)overlapPolicy, "overlapPolicy");
        Intrinsics.checkNotNullParameter(metadata, "metadata");
        try {
            EffectValidator.INSTANCE.validateEffectApplication(player, effectType, durationSeconds, intensity);
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
            ActiveEffect existingEffect = this.storage.getEffect(uUID, effectType);
            if (existingEffect != null && !existingEffect.isExpired()) {
                return this.handleOverlap(player, effectType, durationSeconds, intensity, overlapPolicy, metadata, existingEffect);
            }
            Instant startTime = Instant.now();
            Instant endTime = startTime.plusSeconds(durationSeconds);
            UUID uUID2 = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
            Object object = metadata.get("gameId");
            String string = object instanceof String ? (String)object : null;
            if (string == null) {
                string = "unknown";
            }
            Intrinsics.checkNotNull(startTime);
            Intrinsics.checkNotNull(endTime);
            ActiveEffect effect = new ActiveEffect(null, uUID2, effectType, string, startTime, endTime, intensity, null, metadata, 1, null);
            int taskId = this.scheduler.scheduleDelayed(durationSeconds, () -> EffectManagerImpl.applyEffect$lambda$0(this, player, effectType));
            effect = effect.withTaskId(taskId);
            EffectHandler handler = this.effectHandlers.get((Object)effectType);
            player.sendMessage("\u00a7c[DEBUG] EffectManagerImpl: Applying effect " + effectType);
            player.sendMessage("\u00a7c[DEBUG] Handler found: " + (handler != null));
            if (handler != null) {
                player.sendMessage("\u00a7c[DEBUG] Handler class: " + handler.getClass().getSimpleName());
                player.sendMessage("\u00a7c[DEBUG] Calling handler.apply()...");
                handler.apply(player, effect);
                player.sendMessage("\u00a7c[DEBUG] handler.apply() completed");
            } else {
                player.sendMessage("\u00a7c[DEBUG] No handler registered for " + effectType + "!");
            }
            this.storage.putEffect(effect);
            this.logger.fine("Applied " + effectType + " to " + player.getName() + " for " + durationSeconds + "s (intensity: " + intensity + ")");
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private final boolean handleOverlap(Player player, EffectType effectType, int durationSeconds, double intensity, OverlapPolicy overlapPolicy, Map<String, ? extends Object> metadata, ActiveEffect existingEffect) {
        return switch (WhenMappings.$EnumSwitchMapping$0[overlapPolicy.ordinal()]) {
            case 1 -> {
                UUID v0 = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(v0, "getUniqueId(...)");
                this.removeEffect(v0, effectType);
                yield this.applyEffect(player, effectType, durationSeconds, intensity, overlapPolicy, metadata);
            }
            case 2 -> {
                long remainingSeconds = existingEffect.getRemainingSeconds();
                int newDuration = RangesKt.coerceAtMost((int)(remainingSeconds + (long)durationSeconds), ((Number)EffectValidator.INSTANCE.getDurationRange().getSecond()).intValue());
                UUID v2 = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(v2, "getUniqueId(...)");
                this.removeEffect(v2, effectType);
                yield this.applyEffect(player, effectType, newDuration, intensity, OverlapPolicy.REPLACE, metadata);
            }
            case 3 -> {
                this.logger.fine("Rejected " + effectType + " for " + player.getName() + " (existing effect active)");
                yield false;
            }
            case 4 -> {
                UUID v3 = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(v3, "getUniqueId(...)");
                this.removeEffect(v3, effectType);
                yield this.applyEffect(player, effectType, durationSeconds, intensity, OverlapPolicy.REPLACE, metadata);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public boolean removeEffect(@NotNull UUID playerId, @NotNull EffectType effectType) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter((Object)effectType, "effectType");
        ActiveEffect activeEffect = this.storage.removeEffect(playerId, effectType);
        if (activeEffect == null) {
            return false;
        }
        ActiveEffect effect = activeEffect;
        Integer n = effect.getTaskId();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.scheduler.cancelTask(it);
        }
        EffectHandler handler = this.effectHandlers.get((Object)effectType);
        if (handler != null) {
            Player player = this.plugin.getServer().getPlayer(playerId);
            if (player != null) {
                Player player2 = player;
                boolean bl = false;
                handler.remove(player2, effect);
            }
        }
        this.logger.fine("Removed " + effectType + " from player " + playerId);
        return true;
    }

    @Override
    public int removeAllEffects(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        List<ActiveEffect> effects = this.storage.removeAllEffects(playerId);
        Iterable $this$forEach$iv = effects;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            EffectHandler handler;
            ActiveEffect effect = (ActiveEffect)element$iv;
            boolean bl = false;
            Integer n = effect.getTaskId();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                this.scheduler.cancelTask(it);
            }
            if ((handler = this.effectHandlers.get((Object)effect.getEffectType())) == null) continue;
            if (this.plugin.getServer().getPlayer(playerId) == null) continue;
            boolean bl3 = false;
            handler.remove(player, effect);
        }
        this.logger.fine("Removed " + effects.size() + " effects from player " + playerId);
        return effects.size();
    }

    @Override
    public boolean hasEffect(@NotNull UUID playerId, @NotNull EffectType effectType) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter((Object)effectType, "effectType");
        return this.storage.hasEffect(playerId, effectType);
    }

    @Override
    @Nullable
    public ActiveEffect getActiveEffect(@NotNull UUID playerId, @NotNull EffectType effectType) {
        ActiveEffect activeEffect;
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter((Object)effectType, "effectType");
        ActiveEffect activeEffect2 = this.storage.getEffect(playerId, effectType);
        if (activeEffect2 != null) {
            ActiveEffect activeEffect3;
            ActiveEffect it = activeEffect3 = activeEffect2;
            boolean bl = false;
            activeEffect = !it.isExpired() ? activeEffect3 : null;
        } else {
            activeEffect = null;
        }
        return activeEffect;
    }

    @Override
    public long getRemainingTime(@NotNull UUID playerId, @NotNull EffectType effectType) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Intrinsics.checkNotNullParameter((Object)effectType, "effectType");
        ActiveEffect activeEffect = this.storage.getEffect(playerId, effectType);
        return activeEffect != null ? activeEffect.getRemainingSeconds() : 0L;
    }

    @Override
    @NotNull
    public Set<EffectType> getActiveEffectTypes(@NotNull UUID playerId) {
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Map<EffectType, ActiveEffect> $this$filterValues$iv = this.storage.getAllEffects(playerId);
        boolean $i$f$filterValues = false;
        LinkedHashMap<EffectType, ActiveEffect> result$iv = new LinkedHashMap<EffectType, ActiveEffect>();
        for (Map.Entry<EffectType, ActiveEffect> entry$iv : $this$filterValues$iv.entrySet()) {
            ActiveEffect it = entry$iv.getValue();
            boolean bl = false;
            if (!(!it.isExpired())) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return ((Map)result$iv).keySet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ActiveEffect> getActiveEffects(@NotNull UUID playerId) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(playerId, "playerId");
        Iterable $this$filter$iv = this.storage.getAllEffects(playerId).values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ActiveEffect it = (ActiveEffect)element$iv$iv;
            boolean bl = false;
            if (!(!it.isExpired())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((List)destination$iv$iv);
    }

    @Override
    public int cleanupExpired() {
        int cleaned = this.storage.cleanupExpired();
        if (cleaned > 0) {
            this.logger.fine("Cleaned up " + cleaned + " expired effects");
        }
        return cleaned;
    }

    @Override
    public void clearAll() {
        Iterable $this$forEach$iv = this.storage.getAllPlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID playerId = (UUID)element$iv;
            boolean bl = false;
            this.removeAllEffects(playerId);
        }
        this.storage.clearAll();
    }

    @NotNull
    public final Map<String, Object> getStats() {
        Map<String, Object> storageStats = this.storage.getStats();
        Map<String, Integer> schedulerStats = MapsKt.mapOf(TuplesKt.to("scheduled_tasks", this.scheduler.getActiveTaskCount()));
        return MapsKt.plus(storageStats, schedulerStats);
    }

    private static final Unit applyEffect$lambda$0(EffectManagerImpl this$0, Player $player, EffectType $effectType) {
        UUID uUID = $player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        this$0.removeEffect(uUID, $effectType);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OverlapPolicy.values().length];
            try {
                nArray[OverlapPolicy.REPLACE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OverlapPolicy.EXTEND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OverlapPolicy.REJECT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OverlapPolicy.STACK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

