/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.i18n;

import com.hideandseek.i18n.LanguagePreferenceManager;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.libs.kotlin.text.StringsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u0012H\u0016J\b\u0010\u001b\u001a\u00020\rH\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u001e\u001a\u00020\u0017H\u0016J\b\u0010\u001f\u001a\u00020\u0017H\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0017H\u0002J\u0014\u0010#\u001a\u0004\u0018\u00010\r2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/hideandseek/i18n/LanguagePreferenceManagerImpl;", "Lcom/hideandseek/i18n/LanguagePreferenceManager;", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "languagesFile", "Ljava/io/File;", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "preferenceCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Ljava/util/Locale;", "defaultLanguage", "autoDetectEnabled", "", "availableLanguages", "", "getLocale", "player", "Lorg/bukkit/entity/Player;", "setLocale", "", "locale", "saveImmediately", "getAvailableLanguages", "getDefaultLanguage", "isAutoDetectEnabled", "removePreference", "saveAll", "reload", "getPreferenceCount", "", "saveConfig", "parseLocale", "localeString", "", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nLanguagePreferenceManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguagePreferenceManagerImpl.kt\ncom/hideandseek/i18n/LanguagePreferenceManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1#2:211\n1#2:222\n1617#3,9:212\n1869#3:221\n1870#3:223\n1626#3:224\n1869#3,2:225\n*S KotlinDebug\n*F\n+ 1 LanguagePreferenceManagerImpl.kt\ncom/hideandseek/i18n/LanguagePreferenceManagerImpl\n*L\n142#1:222\n142#1:212,9\n142#1:221\n142#1:223\n142#1:224\n149#1:225,2\n*E\n"})
public final class LanguagePreferenceManagerImpl
implements LanguagePreferenceManager {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final File languagesFile;
    @NotNull
    private FileConfiguration config;
    @NotNull
    private final ConcurrentHashMap<UUID, Locale> preferenceCache;
    @NotNull
    private Locale defaultLanguage;
    private boolean autoDetectEnabled;
    @NotNull
    private List<Locale> availableLanguages;

    public LanguagePreferenceManagerImpl(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        this.languagesFile = new File(this.plugin.getDataFolder(), "languages.yml");
        this.config = (FileConfiguration)new YamlConfiguration();
        this.preferenceCache = new ConcurrentHashMap();
        Locale locale = Locale.JAPANESE;
        Intrinsics.checkNotNullExpressionValue(locale, "JAPANESE");
        this.defaultLanguage = locale;
        this.autoDetectEnabled = true;
        this.availableLanguages = CollectionsKt.emptyList();
        this.reload();
    }

    @Override
    @NotNull
    public Locale getLocale(@NotNull Player player) {
        Locale clientLocale;
        Locale locale;
        Intrinsics.checkNotNullParameter(player, "player");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        Locale locale2 = this.preferenceCache.get(uuid);
        if (locale2 != null) {
            Locale it = locale2;
            boolean bl = false;
            return it;
        }
        String savedLanguage = this.config.getString("players." + uuid);
        if (savedLanguage != null && (locale = this.parseLocale(savedLanguage)) != null && this.availableLanguages.contains(locale)) {
            ((Map)this.preferenceCache).put(uuid, locale);
            return locale;
        }
        if (this.autoDetectEnabled && (clientLocale = this.parseLocale(player.locale().toString())) != null && this.availableLanguages.contains(clientLocale)) {
            this.setLocale(player, clientLocale, false);
            return clientLocale;
        }
        Locale defaultLoc = this.defaultLanguage;
        ((Map)this.preferenceCache).put(uuid, defaultLoc);
        return defaultLoc;
    }

    @Override
    public void setLocale(@NotNull Player player, @NotNull Locale locale, boolean saveImmediately) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(locale, "locale");
        if (!this.availableLanguages.contains(locale)) {
            boolean bl = false;
            String string = "Language " + locale.toLanguageTag() + " is not available. Available: " + CollectionsKt.joinToString$default(this.availableLanguages, null, null, null, 0, null, LanguagePreferenceManagerImpl::setLocale$lambda$0$0, 31, null);
            throw new IllegalArgumentException(string.toString());
        }
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        ((Map)this.preferenceCache).put(uuid, locale);
        this.config.set("players." + uuid, (Object)locale.toLanguageTag());
        if (saveImmediately) {
            this.saveConfig();
        } else {
            BukkitTask bukkitTask = this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, () -> LanguagePreferenceManagerImpl.setLocale$lambda$1(this));
            Intrinsics.checkNotNull(bukkitTask);
        }
    }

    @Override
    @NotNull
    public List<Locale> getAvailableLanguages() {
        return this.availableLanguages;
    }

    @Override
    @NotNull
    public Locale getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Override
    public boolean isAutoDetectEnabled() {
        return this.autoDetectEnabled;
    }

    @Override
    public void removePreference(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        UUID uUID = player.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        UUID uuid = uUID;
        this.preferenceCache.remove(uuid);
        this.config.set("players." + uuid, null);
        this.plugin.getServer().getScheduler().runTaskAsynchronously(this.plugin, () -> LanguagePreferenceManagerImpl.removePreference$lambda$0(this));
    }

    @Override
    public void saveAll() {
        this.saveConfig();
    }

    @Override
    public void reload() {
        List<Locale> list;
        Object element$iv$iv$iv;
        Locale[] $this$mapNotNullTo$iv$iv;
        List<Locale> $this$mapNotNull$iv;
        if (!this.languagesFile.exists()) {
            this.plugin.saveResource("languages.yml", false);
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)this.languagesFile);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        this.config = (FileConfiguration)yamlConfiguration;
        Locale locale = this.parseLocale(this.config.getString("settings.default-language", "ja_JP"));
        if (locale == null) {
            Locale locale2 = Locale.JAPANESE;
            locale = locale2;
            Intrinsics.checkNotNullExpressionValue(locale2, "JAPANESE");
        }
        this.defaultLanguage = locale;
        this.autoDetectEnabled = this.config.getBoolean("settings.auto-detect-client-locale", true);
        List list2 = this.config.getStringList("settings.available-languages");
        Intrinsics.checkNotNullExpressionValue(list2, "getStringList(...)");
        List langStrings = list2;
        Iterable iterable = langStrings;
        LanguagePreferenceManagerImpl languagePreferenceManagerImpl = this;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Locale it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.parseLocale(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        LanguagePreferenceManagerImpl languagePreferenceManagerImpl2 = languagePreferenceManagerImpl;
        $this$mapNotNull$iv = (List)destination$iv$iv;
        if ($this$mapNotNull$iv.isEmpty()) {
            languagePreferenceManagerImpl = languagePreferenceManagerImpl2;
            boolean bl = false;
            $this$mapNotNullTo$iv$iv = new Locale[]{Locale.JAPANESE, Locale.US};
            list = CollectionsKt.listOf($this$mapNotNullTo$iv$iv);
            languagePreferenceManagerImpl2 = languagePreferenceManagerImpl;
        } else {
            list = $this$mapNotNull$iv;
        }
        languagePreferenceManagerImpl2.availableLanguages = list;
        this.preferenceCache.clear();
        ConfigurationSection playersSection = this.config.getConfigurationSection("players");
        Object object = playersSection;
        if (object != null && (object = object.getKeys(false)) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                String uuidString = (String)element$iv;
                boolean bl = false;
                try {
                    element$iv$iv$iv = UUID.fromString(uuidString);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid UUID in languages.yml: " + uuidString);
                    continue;
                }
                Object uuid = element$iv$iv$iv;
                String localeString = this.config.getString("players." + uuidString);
                Locale locale3 = this.parseLocale(localeString);
                if (locale3 == null || !this.availableLanguages.contains(locale3)) continue;
                ((Map)this.preferenceCache).put(uuid, locale3);
            }
        }
        this.plugin.getLogger().info("Loaded " + this.preferenceCache.size() + " language preferences");
    }

    @Override
    public int getPreferenceCount() {
        Object object = this.config.getConfigurationSection("players");
        return object != null && (object = object.getKeys(false)) != null ? object.size() : 0;
    }

    private final synchronized void saveConfig() {
        try {
            this.config.save(this.languagesFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to save languages.yml: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private final Locale parseLocale(String localeString) {
        Locale locale;
        if (localeString == null || StringsKt.isBlank(localeString)) {
            return null;
        }
        try {
            String normalized = StringsKt.replace$default(localeString, "_", "-", false, 4, null);
            locale = Locale.forLanguageTag(normalized);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to parse locale: " + localeString);
            locale = null;
        }
        return locale;
    }

    private static final CharSequence setLocale$lambda$0$0(Locale it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string = it.toLanguageTag();
        Intrinsics.checkNotNullExpressionValue(string, "toLanguageTag(...)");
        return string;
    }

    private static final void setLocale$lambda$1(LanguagePreferenceManagerImpl this$0) {
        this$0.saveConfig();
    }

    private static final void removePreference$lambda$0(LanguagePreferenceManagerImpl this$0) {
        this$0.saveConfig();
    }
}

