/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.listeners;

import com.hideandseek.HideAndSeekPlugin;
import com.hideandseek.config.CaptureMode;
import com.hideandseek.config.ConfigManager;
import com.hideandseek.disguise.DisguiseManager;
import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.game.GameResult;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.game.PlayerRole;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.NoWhenBranchMatchedException;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.points.PointManager;
import com.hideandseek.strength.SeekerStrengthManager;
import com.hideandseek.utils.MessageUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/hideandseek/listeners/EntityDamageByEntityListener;", "Lorg/bukkit/event/Listener;", "disguiseManager", "Lcom/hideandseek/disguise/DisguiseManager;", "gameManager", "Lcom/hideandseek/game/GameManager;", "pointManager", "Lcom/hideandseek/points/PointManager;", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lcom/hideandseek/disguise/DisguiseManager;Lcom/hideandseek/game/GameManager;Lcom/hideandseek/points/PointManager;Lorg/bukkit/plugin/Plugin;)V", "onEntityDamageByEntity", "", "event", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nEntityDamageByEntityListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityDamageByEntityListener.kt\ncom/hideandseek/listeners/EntityDamageByEntityListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,150:1\n1869#2,2:151\n216#3,2:153\n*S KotlinDebug\n*F\n+ 1 EntityDamageByEntityListener.kt\ncom/hideandseek/listeners/EntityDamageByEntityListener\n*L\n90#1:151,2\n126#1:153,2\n*E\n"})
public final class EntityDamageByEntityListener
implements Listener {
    @NotNull
    private final DisguiseManager disguiseManager;
    @NotNull
    private final GameManager gameManager;
    @Nullable
    private final PointManager pointManager;
    @NotNull
    private final Plugin plugin;

    public EntityDamageByEntityListener(@NotNull DisguiseManager disguiseManager, @NotNull GameManager gameManager, @Nullable PointManager pointManager, @NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(disguiseManager, "disguiseManager");
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.disguiseManager = disguiseManager;
        this.gameManager = gameManager;
        this.pointManager = pointManager;
        this.plugin = plugin;
    }

    @EventHandler
    public final void onEntityDamageByEntity(@NotNull EntityDamageByEntityEvent event) {
        int n;
        SeekerStrengthManager strengthManager;
        Object element$iv2;
        int n2;
        int n3;
        ProjectileSource projectileSource;
        Intrinsics.checkNotNullParameter(event, "event");
        Entity entity = event.getEntity();
        Player player = entity instanceof Player ? (Player)entity : null;
        if (player == null) {
            return;
        }
        Player victim = player;
        Entity entity2 = event.getDamager();
        Intrinsics.checkNotNullExpressionValue(entity2, "getDamager(...)");
        Entity damager = entity2;
        Object object = damager instanceof Player ? (Player)damager : (damager instanceof Projectile ? ((projectileSource = ((Projectile)damager).getShooter()) instanceof Player ? (Player)projectileSource : null) : null);
        if (object == null) {
            return;
        }
        Player attacker = object;
        Game game = this.gameManager.getActiveGame();
        if (game == null) {
            return;
        }
        Game game2 = game;
        PlayerGameData playerGameData = game2.getPlayers().get(attacker.getUniqueId());
        if (playerGameData == null) {
            return;
        }
        PlayerGameData attackerData = playerGameData;
        PlayerGameData playerGameData2 = game2.getPlayers().get(victim.getUniqueId());
        if (playerGameData2 == null) {
            return;
        }
        PlayerGameData victimData = playerGameData2;
        if (attackerData.getRole() == PlayerRole.HIDER) {
            event.setCancelled(true);
            if (victimData.getRole() == PlayerRole.SEEKER) {
                MessageUtil.INSTANCE.send((CommandSender)attacker, "&c\u4eba\u9593\u306f\u9b3c\u306b\u30c0\u30e1\u30fc\u30b8\u3092\u4e0e\u3048\u3089\u308c\u307e\u305b\u3093");
            }
            return;
        }
        if (attackerData.getRole() == PlayerRole.SEEKER && victimData.getRole() == PlayerRole.SEEKER) {
            this.plugin.getLogger().info("[SeekerCombat] " + attacker.getName() + " is attacking " + victim.getName() + " (seeker vs seeker PK)");
            return;
        }
        event.setCancelled(true);
        if (victimData.getRole() != PlayerRole.HIDER) {
            return;
        }
        if (victimData.isCaptured()) {
            return;
        }
        UUID uUID = victim.getUniqueId();
        Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
        if (this.disguiseManager.isDisguised(uUID)) {
            this.disguiseManager.undisguise(victim, "capture");
        }
        victimData.setCaptured(true);
        attackerData.recordCapture();
        PointManager pointManager = this.pointManager;
        if (pointManager != null) {
            UUID uUID2 = victim.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID2, "getUniqueId(...)");
            n3 = pointManager.getPoints(uUID2);
        } else {
            n3 = 0;
        }
        int victimPointsBefore = n3;
        int basePoints = this.plugin.getConfig().getInt("points.capture-base-points", 50);
        double stealPercentage = this.plugin.getConfig().getDouble("points.capture-steal-percentage", 0.5);
        PointManager pointManager2 = this.pointManager;
        if (pointManager2 != null) {
            UUID uUID3 = attacker.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID3, "getUniqueId(...)");
            UUID uUID4 = victim.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID4, "getUniqueId(...)");
            n2 = pointManager2.handleCapture(game2, uUID3, uUID4, basePoints, stealPercentage);
        } else {
            n2 = 0;
        }
        int pointsAwarded = n2;
        Iterable $this$forEach$iv = game2.getPlayers().values();
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Player player2;
            PlayerGameData playerData = (PlayerGameData)element$iv2;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)playerData.getUuid()) == null) continue;
            boolean bl2 = false;
            MessageUtil.INSTANCE.send((CommandSender)player2, "&c" + attacker.getName() + " &7\u304c &a" + victim.getName() + " &7\u3092\u9b3c\u5316\u3057\u305f\uff01 &7(\u9b3c\u5316\u6e08\u307f: " + game2.getCaptured().size() + "/" + (game2.getHiders().size() + game2.getCaptured().size()) + ")");
        }
        if (pointsAwarded > 0) {
            int n4;
            MessageUtil.INSTANCE.send((CommandSender)attacker, "&e+" + pointsAwarded + " \u30dd\u30a4\u30f3\u30c8\u7372\u5f97 &7(\u9b3c\u5316)");
            PointManager pointManager3 = this.pointManager;
            if (pointManager3 != null) {
                UUID uUID5 = victim.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID5, "getUniqueId(...)");
                n4 = pointManager3.getPoints(uUID5);
            } else {
                n4 = 0;
            }
            int victimPointsAfter = n4;
            int pointsLost = victimPointsBefore - victimPointsAfter;
            if (pointsLost > 0) {
                MessageUtil.INSTANCE.send((CommandSender)victim, "&c-" + pointsLost + " \u30dd\u30a4\u30f3\u30c8 &7(" + attacker.getName() + "\u306b\u596a\u308f\u308c\u305f)");
            }
        }
        int strengthPointsPerCapture = this.plugin.getConfig().getInt("seeker-strength.points-per-capture", 200);
        element$iv2 = this.plugin;
        HideAndSeekPlugin hideAndSeekPlugin = element$iv2 instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)((Object)element$iv2) : null;
        SeekerStrengthManager seekerStrengthManager = strengthManager = hideAndSeekPlugin != null ? hideAndSeekPlugin.getSeekerStrengthManager() : null;
        if (seekerStrengthManager != null) {
            UUID uUID6 = attacker.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID6, "getUniqueId(...)");
            seekerStrengthManager.addStrength(uUID6, strengthPointsPerCapture);
        }
        SeekerStrengthManager seekerStrengthManager2 = strengthManager;
        if (seekerStrengthManager2 != null) {
            UUID uUID7 = attacker.getUniqueId();
            Intrinsics.checkNotNullExpressionValue(uUID7, "getUniqueId(...)");
            n = seekerStrengthManager2.getStrength(uUID7);
        } else {
            n = 0;
        }
        int totalStrength = n;
        MessageUtil.INSTANCE.send((CommandSender)attacker, "&6+" + strengthPointsPerCapture + " \u5f37\u3055\u30dd\u30a4\u30f3\u30c8 &7(\u5408\u8a08: " + totalStrength + ")");
        this.gameManager.handleCapture(attacker, victim);
        Plugin bl = this.plugin;
        HideAndSeekPlugin hideAndSeekPlugin2 = bl instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)bl : null;
        ConfigManager configManager = hideAndSeekPlugin2 != null ? hideAndSeekPlugin2.getConfigManager() : null;
        Object object2 = configManager;
        if (object2 == null || (object2 = ((ConfigManager)object2).getCaptureMode()) == null) {
            object2 = CaptureMode.INFECTION;
        }
        Object captureMode = object2;
        List<UUID> remainingHiders = game2.getHiders();
        this.plugin.getLogger().info("[DEBUG] Capture mode: " + (CaptureMode)((Object)captureMode));
        this.plugin.getLogger().info("[DEBUG] Remaining hiders after capture: " + remainingHiders.size());
        Map<UUID, PlayerGameData> $this$forEach$iv2 = game2.getPlayers();
        boolean $i$f$forEach2 = false;
        Iterator<Map.Entry<UUID, PlayerGameData>> iterator2 = $this$forEach$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<UUID, PlayerGameData> element$iv3;
            Map.Entry<UUID, PlayerGameData> entry = element$iv3 = iterator2.next();
            boolean bl3 = false;
            UUID uuid = entry.getKey();
            PlayerGameData data = entry.getValue();
            Object object3 = Bukkit.getPlayer((UUID)uuid);
            if (object3 == null || (object3 = object3.getName()) == null) {
                object3 = "Unknown";
            }
            Object playerName = object3;
            this.plugin.getLogger().info("[DEBUG] Player: " + (String)playerName + ", Role: " + data.getRole() + ", isCaptured: " + data.isCaptured());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[((Enum)captureMode).ordinal()]) {
            case 1: {
                if (!remainingHiders.isEmpty()) break;
                this.plugin.getLogger().info("[DEBUG] All hiders captured in SPECTATOR mode - ending game");
                this.gameManager.endGame(GameResult.SEEKER_WIN);
                break;
            }
            case 2: {
                if (!remainingHiders.isEmpty()) break;
                this.plugin.getLogger().info("[DEBUG] All players became seekers in INFECTION mode - ending game");
                this.gameManager.endGame(GameResult.SEEKER_WIN);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CaptureMode.values().length];
            try {
                nArray[CaptureMode.SPECTATOR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CaptureMode.INFECTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

