/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.listeners;

import com.hideandseek.game.Game;
import com.hideandseek.game.GameManager;
import com.hideandseek.game.GameResult;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.game.PlayerRole;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.spectator.SpectatorManager;
import com.hideandseek.spectator.SpectatorTeam;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/hideandseek/listeners/SpectatorEventListener;", "Lorg/bukkit/event/Listener;", "spectatorManager", "Lcom/hideandseek/spectator/SpectatorManager;", "gameManager", "Lcom/hideandseek/game/GameManager;", "<init>", "(Lcom/hideandseek/spectator/SpectatorManager;Lcom/hideandseek/game/GameManager;)V", "onPlayerJoin", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "EasyHideAndSeek"})
public final class SpectatorEventListener
implements Listener {
    @NotNull
    private final SpectatorManager spectatorManager;
    @NotNull
    private final GameManager gameManager;

    public SpectatorEventListener(@NotNull SpectatorManager spectatorManager, @NotNull GameManager gameManager) {
        Intrinsics.checkNotNullParameter(spectatorManager, "spectatorManager");
        Intrinsics.checkNotNullParameter(gameManager, "gameManager");
        this.spectatorManager = spectatorManager;
        this.gameManager = gameManager;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        this.spectatorManager.restoreSpectatorState(player2);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        SpectatorTeam spectatorTeam = this.spectatorManager.getSpectatorTeam();
        if (spectatorTeam.contains(player2)) {
            spectatorTeam.removePlayer(player2);
        }
        Game game = this.gameManager.getActiveGame();
        if (game == null) {
            return;
        }
        Game game2 = game;
        PlayerGameData playerGameData = game2.getPlayers().get(player2.getUniqueId());
        if (playerGameData == null) {
            return;
        }
        PlayerGameData playerData = playerGameData;
        if (playerData.getRole() == PlayerRole.HIDER && !playerData.isCaptured()) {
            game2.getPlayers().remove(player2.getUniqueId());
            List<UUID> remainingHiders = game2.getHiders();
            if (remainingHiders.isEmpty()) {
                this.gameManager.endGame(GameResult.SEEKER_WIN);
            }
        }
    }
}

