/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.scoreboard;

import com.hideandseek.HideAndSeekPlugin;
import com.hideandseek.game.Game;
import com.hideandseek.game.GamePhase;
import com.hideandseek.game.PlayerGameData;
import com.hideandseek.game.PlayerRole;
import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.NoWhenBranchMatchedException;
import com.hideandseek.libs.kotlin.Pair;
import com.hideandseek.libs.kotlin.TuplesKt;
import com.hideandseek.libs.kotlin.collections.CollectionsKt;
import com.hideandseek.libs.kotlin.collections.MapsKt;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import com.hideandseek.libs.kotlin.text.StringsKt;
import com.hideandseek.points.PointManager;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\rJ\u0006\u0010\u0011\u001a\u00020\rJ\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/hideandseek/scoreboard/GameScoreboard;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "updateTask", "Lorg/bukkit/scheduler/BukkitTask;", "playerScoreboards", "", "Ljava/util/UUID;", "Lorg/bukkit/scoreboard/Scoreboard;", "startUpdating", "", "game", "Lcom/hideandseek/game/Game;", "stopUpdating", "clearAll", "createScoreboard", "player", "Lorg/bukkit/entity/Player;", "copyTeamsFromMain", "targetScoreboard", "updateScoreboard", "clearScoreboard", "addPlayer", "removePlayer", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nGameScoreboard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameScoreboard.kt\ncom/hideandseek/scoreboard/GameScoreboard\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n1869#2,2:252\n1869#2,2:254\n1869#2:256\n1869#2,2:257\n1870#2:259\n1869#2,2:260\n1878#2,3:262\n1869#2,2:265\n*S KotlinDebug\n*F\n+ 1 GameScoreboard.kt\ncom/hideandseek/scoreboard/GameScoreboard\n*L\n32#1:252,2\n64#1:254,2\n120#1:256\n143#1:257,2\n120#1:259\n160#1:260,2\n221#1:262,3\n40#1:265,2\n*E\n"})
public final class GameScoreboard {
    @NotNull
    private final Plugin plugin;
    @Nullable
    private BukkitTask updateTask;
    @NotNull
    private final Map<UUID, Scoreboard> playerScoreboards;

    public GameScoreboard(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        this.playerScoreboards = new LinkedHashMap();
    }

    public final void startUpdating(@NotNull Game game) {
        Intrinsics.checkNotNullParameter(game, "game");
        this.stopUpdating();
        Iterable $this$forEach$iv = game.getPlayers().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            this.createScoreboard(player, game);
        }
        this.updateTask = Bukkit.getScheduler().runTaskTimer(this.plugin, () -> GameScoreboard.startUpdating$lambda$1(game, this), 20L, 20L);
        this.plugin.getLogger().info("[Scoreboard] Started scoreboard updates");
    }

    public final void stopUpdating() {
        BukkitTask bukkitTask = this.updateTask;
        if (bukkitTask != null) {
            bukkitTask.cancel();
        }
        this.updateTask = null;
        this.plugin.getLogger().info("[Scoreboard] Stopped scoreboard updates");
    }

    public final void clearAll() {
        this.stopUpdating();
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.playerScoreboards.keySet());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            this.clearScoreboard(player);
        }
        this.playerScoreboards.clear();
        this.plugin.getLogger().info("[Scoreboard] Cleared all scoreboards");
    }

    private final void createScoreboard(Player player, Game game) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        Intrinsics.checkNotNullExpressionValue(scoreboard, "getNewScoreboard(...)");
        Scoreboard scoreboard2 = scoreboard;
        this.copyTeamsFromMain(scoreboard2);
        Objective objective = scoreboard2.registerNewObjective("hideandseek", "dummy", "\u00a76\u00a7l\ud83c\udfae Hide and Seek");
        Intrinsics.checkNotNullExpressionValue(objective, "registerNewObjective(...)");
        Objective objective2 = objective;
        objective2.setDisplaySlot(DisplaySlot.SIDEBAR);
        player.setScoreboard(scoreboard2);
        this.playerScoreboards.put(player.getUniqueId(), scoreboard2);
        this.plugin.getLogger().info("[Scoreboard] Created scoreboard for " + player.getName() + " with teams copied");
        this.updateScoreboard(player, game);
    }

    private final void copyTeamsFromMain(Scoreboard targetScoreboard) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Intrinsics.checkNotNullExpressionValue(scoreboard, "getMainScoreboard(...)");
        Scoreboard mainScoreboard = scoreboard;
        Pair[] pairArray = new Pair[]{TuplesKt.to("hs_seekers", ChatColor.RED), TuplesKt.to("hs_hiders", ChatColor.GREEN), TuplesKt.to("hs_spectators", ChatColor.GRAY)};
        Map teamColors = MapsKt.mapOf(pairArray);
        Object[] objectArray = new Pair[]{TuplesKt.to("hs_seekers", Team.OptionStatus.ALWAYS), TuplesKt.to("hs_hiders", Team.OptionStatus.NEVER), TuplesKt.to("hs_spectators", Team.OptionStatus.ALWAYS)};
        Map teamVisibility = MapsKt.mapOf(objectArray);
        objectArray = new String[]{"hs_seekers", "hs_hiders", "hs_spectators"};
        Iterable $this$forEach$iv = CollectionsKt.listOf(objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Team mainTeam;
            Team newTeam;
            Team.OptionStatus optionStatus;
            ChatColor color;
            String teamName = (String)element$iv;
            boolean bl = false;
            if (mainScoreboard.getTeam(teamName) == null) continue;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(targetScoreboard.registerNewTeam(teamName), "registerNewTeam(...)");
            ChatColor chatColor = (ChatColor)teamColors.get(teamName);
            if (chatColor == null) {
                chatColor = color = ChatColor.WHITE;
            }
            if ((optionStatus = (Team.OptionStatus)teamVisibility.get(teamName)) == null) {
                optionStatus = Team.OptionStatus.ALWAYS;
            }
            Team.OptionStatus visibility = optionStatus;
            newTeam.setColor(color);
            newTeam.setPrefix(switch (WhenMappings.$EnumSwitchMapping$0[color.ordinal()]) {
                case 1 -> "\u00a7c";
                case 2 -> "\u00a7a";
                case 3 -> "\u00a77";
                default -> "";
            });
            newTeam.setSuffix("");
            newTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, visibility);
            Set set = mainTeam.getEntries();
            Intrinsics.checkNotNullExpressionValue(set, "getEntries(...)");
            Iterable $this$forEach$iv2 = set;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String entry = (String)element$iv2;
                boolean bl3 = false;
                newTeam.addEntry(entry);
            }
            this.plugin.getLogger().info("[Scoreboard] Copied team " + teamName + " with " + mainTeam.getEntries().size() + " entries, color=" + color);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateScoreboard(Player player, Game game) {
        Scoreboard scoreboard = this.playerScoreboards.get(player.getUniqueId());
        if (scoreboard == null) {
            return;
        }
        Scoreboard scoreboard2 = scoreboard;
        Objective objective = scoreboard2.getObjective("hideandseek");
        if (objective == null) {
            return;
        }
        Objective objective2 = objective;
        Set set = scoreboard2.getEntries();
        Intrinsics.checkNotNullExpressionValue(set, "getEntries(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String entry = (String)element$iv;
            boolean bl = false;
            scoreboard2.resetScores(entry);
        }
        PlayerGameData playerData = game.getPlayers().get(player.getUniqueId());
        List lines = new ArrayList();
        lines.add("\u00a77");
        switch (WhenMappings.$EnumSwitchMapping$1[game.getPhase().ordinal()]) {
            case 1: {
                long elapsed = (System.currentTimeMillis() - game.getPhaseStartTime()) / (long)1000;
                int remaining = 30 - (int)elapsed;
                boolean bl = lines.add("\u00a7e\u23f0 \u6e96\u5099\u6642\u9593: \u00a7f" + remaining + "\u79d2");
                break;
            }
            case 2: {
                long elapsed = (System.currentTimeMillis() - game.getPhaseStartTime()) / (long)1000;
                int seekTime = 600;
                int remaining = (int)((long)seekTime - elapsed);
                int minutes = remaining / 60;
                int seconds = remaining % 60;
                boolean bl = lines.add("\u00a7e\u23f0 \u6b8b\u308a\u6642\u9593: \u00a7f" + minutes + ":" + StringsKt.padStart(String.valueOf(seconds), 2, '0'));
                break;
            }
            default: {
                boolean bl = lines.add("\u00a7e\u23f0 \u5f85\u6a5f\u4e2d...");
            }
        }
        lines.add("\u00a78");
        int seekers = game.getSeekers().size();
        int hiders = game.getHiders().size();
        int captured = game.getCaptured().size();
        lines.add("\u00a7c\ud83d\udc79 \u9b3c: \u00a7f" + seekers + "\u4eba");
        lines.add("\u00a7a\ud83c\udfc3 \u4eba: \u00a7f" + hiders + "\u4eba");
        lines.add("\u00a77\ud83d\udc80 \u9b3c\u5316\u6e08\u307f: \u00a7f" + captured + "\u4eba");
        lines.add("\u00a79");
        if (playerData != null) {
            int n;
            PointManager pointMgr;
            String roleText = switch (WhenMappings.$EnumSwitchMapping$2[playerData.getRole().ordinal()]) {
                case 1 -> "\u00a7c\u9b3c";
                case 2 -> {
                    if (playerData.isCaptured()) {
                        yield "\u00a77\u9b3c\u5316\u6e08\u307f";
                    }
                    yield "\u00a7a\u4eba";
                }
                case 3 -> "\u00a77\u89b3\u6226\u8005";
                default -> throw new NoWhenBranchMatchedException();
            };
            lines.add("\u00a76\u3042\u306a\u305f: " + roleText);
            Plugin plugin = this.plugin;
            HideAndSeekPlugin hideAndSeekPlugin = plugin instanceof HideAndSeekPlugin ? (HideAndSeekPlugin)plugin : null;
            PointManager pointManager = pointMgr = hideAndSeekPlugin != null ? hideAndSeekPlugin.getPointManager() : null;
            if (pointManager != null) {
                UUID uUID = player.getUniqueId();
                Intrinsics.checkNotNullExpressionValue(uUID, "getUniqueId(...)");
                n = pointManager.getPoints(uUID);
            } else {
                n = 0;
            }
            int points = n;
            lines.add("\u00a7e\u30dd\u30a4\u30f3\u30c8: \u00a7f" + points);
        }
        lines.add("\u00a70");
        Iterable $this$forEachIndexed$iv = CollectionsKt.reversed(lines);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            objective2.getScore((String)line).setScore(index);
        }
    }

    private final void clearScoreboard(Player player) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Intrinsics.checkNotNullExpressionValue(scoreboard, "getMainScoreboard(...)");
        Scoreboard mainScoreboard = scoreboard;
        player.setScoreboard(mainScoreboard);
        this.playerScoreboards.remove(player.getUniqueId());
    }

    public final void addPlayer(@NotNull Player player, @NotNull Game game) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(game, "game");
        this.createScoreboard(player, game);
        this.plugin.getLogger().info("[Scoreboard] Added " + player.getName() + " to scoreboard");
    }

    public final void removePlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.clearScoreboard(player);
        this.plugin.getLogger().info("[Scoreboard] Removed " + player.getName() + " from scoreboard");
    }

    private static final void startUpdating$lambda$1(Game $game, GameScoreboard this$0) {
        Iterable $this$forEach$iv = $game.getPlayers().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            UUID uuid = (UUID)element$iv;
            boolean bl = false;
            if (Bukkit.getPlayer((UUID)uuid) == null) continue;
            boolean bl2 = false;
            this$0.updateScoreboard(player, $game);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ChatColor.values().length];
            try {
                nArray[ChatColor.RED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatColor.GREEN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChatColor.GRAY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[GamePhase.values().length];
            try {
                nArray[GamePhase.PREPARATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GamePhase.SEEKING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[PlayerRole.values().length];
            try {
                nArray[PlayerRole.SEEKER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerRole.HIDER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlayerRole.SPECTATOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

