/*
 * Decompiled with CFR 0.152.
 */
package com.hideandseek.utils;

import com.hideandseek.libs.kotlin.Metadata;
import com.hideandseek.libs.kotlin.Unit;
import com.hideandseek.libs.kotlin.jvm.functions.Function0;
import com.hideandseek.libs.kotlin.jvm.internal.Intrinsics;
import com.hideandseek.libs.kotlin.jvm.internal.SourceDebugExtension;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u001c\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0014\u001a\u00020\u000eJ\u0006\u0010\u0015\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/hideandseek/utils/EffectScheduler;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "tasks", "", "", "Lorg/bukkit/scheduler/BukkitTask;", "scheduleDelayed", "delaySeconds", "callback", "Lcom/hideandseek/libs/kotlin/Function0;", "", "scheduleRepeating", "intervalSeconds", "cancelTask", "", "taskId", "cancelAll", "getActiveTaskCount", "cleanupCompletedTasks", "EasyHideAndSeek"})
@SourceDebugExtension(value={"SMAP\nEffectScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EffectScheduler.kt\ncom/hideandseek/utils/EffectScheduler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1869#2,2:96\n*S KotlinDebug\n*F\n+ 1 EffectScheduler.kt\ncom/hideandseek/utils/EffectScheduler\n*L\n71#1:96,2\n*E\n"})
public final class EffectScheduler {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final Map<Integer, BukkitTask> tasks;

    public EffectScheduler(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        this.tasks = new LinkedHashMap();
    }

    public final int scheduleDelayed(int delaySeconds, @NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, "callback");
        BukkitTask bukkitTask = this.plugin.getServer().getScheduler().runTaskLater(this.plugin, () -> EffectScheduler.scheduleDelayed$lambda$0(callback), (long)delaySeconds * 20L);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskLater(...)");
        BukkitTask task2 = bukkitTask;
        this.tasks.put(task2.getTaskId(), task2);
        return task2.getTaskId();
    }

    public final int scheduleRepeating(int intervalSeconds, @NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, "callback");
        BukkitTask bukkitTask = this.plugin.getServer().getScheduler().runTaskTimer(this.plugin, () -> EffectScheduler.scheduleRepeating$lambda$0(callback), (long)intervalSeconds * 20L, (long)intervalSeconds * 20L);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "runTaskTimer(...)");
        BukkitTask task2 = bukkitTask;
        this.tasks.put(task2.getTaskId(), task2);
        return task2.getTaskId();
    }

    public final boolean cancelTask(int taskId) {
        BukkitTask bukkitTask = this.tasks.remove(taskId);
        if (bukkitTask == null) {
            return false;
        }
        BukkitTask task2 = bukkitTask;
        task2.cancel();
        return true;
    }

    public final void cancelAll() {
        Iterable $this$forEach$iv = this.tasks.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BukkitTask it = (BukkitTask)element$iv;
            boolean bl = false;
            it.cancel();
        }
        this.tasks.clear();
    }

    public final int getActiveTaskCount() {
        return this.tasks.size();
    }

    public final void cleanupCompletedTasks() {
        Iterator<Map.Entry<Integer, BukkitTask>> iterator2 = this.tasks.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Integer, BukkitTask> entry = iterator2.next();
            if (!entry.getValue().isCancelled()) continue;
            iterator2.remove();
        }
    }

    private static final void scheduleDelayed$lambda$0(Function0 $callback) {
        $callback.invoke();
    }

    private static final void scheduleRepeating$lambda$0(Function0 $callback) {
        $callback.invoke();
    }
}

