/*
 * Decompiled with CFR 0.152.
 */
package net.zsvan.wanderingspoils.procedures;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.zsvan.wanderingspoils.WanderingTraderConfig;
import net.zsvan.wanderingspoils.init.WanderingSpoilsModGameRules;

@EventBusSubscriber
public class WanderingTraderDeathProcedure {
    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntity() != null) {
            WanderingTraderDeathProcedure.execute((Event)event, (LevelAccessor)event.getEntity().level(), event.getSource(), (Entity)event.getEntity());
        }
    }

    public static void execute(LevelAccessor world, DamageSource damagesource, Entity entity) {
        WanderingTraderDeathProcedure.execute(null, world, damagesource, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, DamageSource damagesource, Entity entity) {
        ServerLevel _serverLevelGR1;
        if (damagesource == null || entity == null) {
            return;
        }
        String itemId = "";
        boolean isCreativeKill = false;
        boolean shouldDrop = false;
        ItemStack result = ItemStack.EMPTY;
        ItemStack emeralds = ItemStack.EMPTY;
        double droppedCount = 0.0;
        double emeraldCount = 0.0;
        double dropAmount = 0.0;
        double scatter = 0.0;
        if (world.isClientSide()) {
            return;
        }
        if (!(world instanceof ServerLevel) || !(_serverLevelGR1 = (ServerLevel)world).getGameRules().getBoolean(WanderingSpoilsModGameRules.DO_WANDERING_TRADER_DROPS)) {
            return;
        }
        if (entity instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)entity;
            if (damagesource.isCreativePlayer()) {
                isCreativeKill = true;
            }
            MerchantOffers offers = trader.getOffers();
            ArrayList<ItemStack> stockItems = new ArrayList<ItemStack>();
            for (MerchantOffer offer : offers) {
                result = offer.getResult().copy();
                itemId = BuiltInRegistries.ITEM.getKey((Object)result.getItem()).toString();
                if (WanderingTraderConfig.itemBlacklist.contains(itemId)) continue;
                stockItems.add(result);
            }
            Random random = new Random();
            for (ItemStack stockItem : stockItems) {
                shouldDrop = isCreativeKill && WanderingTraderConfig.dropAllOnCreativeKill || random.nextDouble() < WanderingTraderConfig.dropChance;
                if (!shouldDrop) continue;
                WanderingTraderDeathProcedure.dropItem(trader, stockItem, random);
                droppedCount += 1.0;
            }
            if (random.nextDouble() < WanderingTraderConfig.dropChance) {
                emeraldCount = 1 + random.nextInt(WanderingTraderConfig.maxEmeraldDrop);
                emeralds = new ItemStack((ItemLike)Items.EMERALD, (int)emeraldCount).copy();
                WanderingTraderDeathProcedure.dropItem(trader, emeralds, random);
                droppedCount += 1.0;
            }
        }
    }

    private static void dropItem(WanderingTrader trader, ItemStack stockItem, Random random) {
        double dropAmount = 0.0;
        double scatter = 0.0;
        dropAmount = stockItem.getCount();
        if (WanderingTraderConfig.reduceQuantities) {
            dropAmount = Math.min(stockItem.getCount(), WanderingTraderConfig.minDropAmount + random.nextInt(WanderingTraderConfig.maxDropAmount) - (WanderingTraderConfig.minDropAmount + 1));
        }
        ItemStack dropItem = stockItem.copy();
        dropItem.setCount((int)dropAmount);
        ItemEntity itemEntity = new ItemEntity(trader.level(), trader.getX(), trader.getY(), trader.getZ(), dropItem);
        scatter = WanderingTraderConfig.scatterVelocity;
        itemEntity.setDeltaMovement((random.nextDouble() - 0.5) * scatter, 0.2 + random.nextDouble() * 0.1, (random.nextDouble() - 0.5) * scatter);
        trader.level().addFreshEntity((Entity)itemEntity);
    }
}

