/*
 * Decompiled with CFR 0.152.
 */
package net.zsvan.wanderingspoils;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class WanderingTraderConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.DoubleValue DROP_CHANCE;
    public static final ForgeConfigSpec.IntValue MIN_DROP_AMOUNT;
    public static final ForgeConfigSpec.IntValue MAX_DROP_AMOUNT;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ITEM_BLACKLIST;
    public static final ForgeConfigSpec.DoubleValue SCATTER_VELOCITY;
    public static final ForgeConfigSpec.BooleanValue REDUCE_QUANTITIES;
    public static final ForgeConfigSpec.BooleanValue DROP_ALL_ON_CREATIVE_KILL;
    public static final ForgeConfigSpec.DoubleValue EMERALD_DROP_CHANCE;
    public static final ForgeConfigSpec.IntValue MAX_EMERALD_DROP;
    public static double dropChance;
    public static int minDropAmount;
    public static int maxDropAmount;
    public static List<? extends String> itemBlacklist;
    public static double scatterVelocity;
    public static boolean reduceQuantities;
    public static boolean dropAllOnCreativeKill;
    public static double emeraldDropChance;
    public static int maxEmeraldDrop;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        dropChance = (Double)DROP_CHANCE.get();
        minDropAmount = (Integer)MIN_DROP_AMOUNT.get();
        maxDropAmount = (Integer)MAX_DROP_AMOUNT.get();
        itemBlacklist = (List)ITEM_BLACKLIST.get();
        scatterVelocity = (Double)SCATTER_VELOCITY.get();
        reduceQuantities = (Boolean)REDUCE_QUANTITIES.get();
        dropAllOnCreativeKill = (Boolean)DROP_ALL_ON_CREATIVE_KILL.get();
        emeraldDropChance = (Double)EMERALD_DROP_CHANCE.get();
        maxEmeraldDrop = (Integer)MAX_EMERALD_DROP.get();
    }

    static {
        BUILDER.comment(new String[]{"Wandering Trader Drop Configuration", "", "IMPORTANT: To enable/disable this feature, use the game rule:", "/gamerule doWanderingTraderDrops true/false", "", "This config only affects the behavior when the feature is enabled via gamerule."});
        BUILDER.push("General Settings");
        DROP_CHANCE = BUILDER.comment("Chance (0.0 to 1.0) for each stock item to drop when wandering trader dies").defineInRange("dropChance", 0.3, 0.0, 1.0);
        MIN_DROP_AMOUNT = BUILDER.comment("Minimum amount of items to drop (when an item is selected to drop)").defineInRange("minDropAmount", 1, 1, 64);
        MAX_DROP_AMOUNT = BUILDER.comment("Maximum amount of items to drop (when an item is selected to drop)").defineInRange("maxDropAmount", 3, 1, 64);
        REDUCE_QUANTITIES = BUILDER.comment("Whether to reduce drop quantities instead of dropping full stacks").define("reduceQuantities", true);
        SCATTER_VELOCITY = BUILDER.comment("How much items scatter when dropped (0.0 = no scatter, 1.0 = lots of scatter)").defineInRange("scatterVelocity", 0.3, 0.0, 2.0);
        BUILDER.pop();
        BUILDER.push("Item Filtering");
        ITEM_BLACKLIST = BUILDER.comment(new String[]{"Items that should never drop from wandering trader stock", "Use minecraft item IDs (e.g., 'minecraft:diamond', 'minecraft:netherite_ingot')", "You can also use mod IDs (e.g., 'yourmod:special_item')"}).defineList("itemBlacklist", List.of("minecraft:dragon_egg", "minecraft:bedrock", "minecraft:barrier"), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.push("Emerald Drops");
        EMERALD_DROP_CHANCE = BUILDER.comment("Chance to drop emeralds when wandering trader dies (separate from stock items)").defineInRange("emeraldDropChance", 0.15, 0.0, 1.0);
        MAX_EMERALD_DROP = BUILDER.comment("Maximum emeralds to drop").defineInRange("maxEmeraldDrop", 5, 0, 64);
        BUILDER.pop();
        BUILDER.push("Special Cases");
        DROP_ALL_ON_CREATIVE_KILL = BUILDER.comment("Drop all stock items when killed by a creative mode player (for testing)").define("dropAllOnCreativeKill", false);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

