/*
 * Decompiled with CFR 0.152.
 */
package net.zsvan.wanderingspoils.procedures;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.zsvan.wanderingspoils.WanderingTraderConfig;
import net.zsvan.wanderingspoils.init.WanderingSpoilsModGameRules;

@Mod.EventBusSubscriber
public class WanderingTraderDeathProcedure {
    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        if (event != null && event.getEntity() != null) {
            WanderingTraderDeathProcedure.execute((Event)event, (LevelAccessor)event.getEntity().m_9236_(), event.getSource(), (Entity)event.getEntity());
        }
    }

    public static void execute(LevelAccessor world, DamageSource damagesource, Entity entity) {
        WanderingTraderDeathProcedure.execute(null, world, damagesource, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, DamageSource damagesource, Entity entity) {
        if (damagesource == null || entity == null) {
            return;
        }
        String itemId = "";
        boolean isCreativeKill = false;
        boolean shouldDrop = false;
        ItemStack result = ItemStack.f_41583_;
        ItemStack emeralds = ItemStack.f_41583_;
        double droppedCount = 0.0;
        double emeraldCount = 0.0;
        double dropAmount = 0.0;
        double scatter = 0.0;
        if (world.m_5776_()) {
            return;
        }
        if (!world.m_6106_().m_5470_().m_46207_(WanderingSpoilsModGameRules.DO_WANDERING_TRADER_DROPS)) {
            return;
        }
        if (entity instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)entity;
            if (damagesource.m_19390_()) {
                isCreativeKill = true;
            }
            MerchantOffers offers = trader.m_6616_();
            ArrayList<ItemStack> stockItems = new ArrayList<ItemStack>();
            for (MerchantOffer offer : offers) {
                result = offer.m_45368_().m_41777_();
                itemId = ForgeRegistries.ITEMS.getKey((Object)result.m_41720_()).toString();
                if (WanderingTraderConfig.itemBlacklist.contains(itemId)) continue;
                stockItems.add(result);
            }
            Random random = new Random();
            for (ItemStack stockItem : stockItems) {
                shouldDrop = isCreativeKill && WanderingTraderConfig.dropAllOnCreativeKill || random.nextDouble() < WanderingTraderConfig.dropChance;
                if (!shouldDrop) continue;
                WanderingTraderDeathProcedure.dropItem(trader, stockItem, random);
                droppedCount += 1.0;
            }
            if (random.nextDouble() < WanderingTraderConfig.dropChance) {
                emeraldCount = 1 + random.nextInt(WanderingTraderConfig.maxEmeraldDrop);
                emeralds = new ItemStack((ItemLike)Items.f_42616_, (int)emeraldCount).m_41777_();
                WanderingTraderDeathProcedure.dropItem(trader, emeralds, random);
                droppedCount += 1.0;
            }
        }
    }

    private static void dropItem(WanderingTrader trader, ItemStack stockItem, Random random) {
        double dropAmount = 0.0;
        double scatter = 0.0;
        dropAmount = stockItem.m_41613_();
        if (WanderingTraderConfig.reduceQuantities) {
            dropAmount = Math.min(stockItem.m_41613_(), WanderingTraderConfig.minDropAmount + random.nextInt(WanderingTraderConfig.maxDropAmount) - (WanderingTraderConfig.minDropAmount + 1));
        }
        ItemStack dropItem = stockItem.m_41777_();
        dropItem.m_41764_((int)dropAmount);
        ItemEntity itemEntity = new ItemEntity(trader.m_9236_(), trader.m_20185_(), trader.m_20186_(), trader.m_20189_(), dropItem);
        scatter = WanderingTraderConfig.scatterVelocity;
        itemEntity.m_20334_((random.nextDouble() - 0.5) * scatter, 0.2 + random.nextDouble() * 0.1, (random.nextDouble() - 0.5) * scatter);
        trader.m_9236_().m_7967_((Entity)itemEntity);
    }
}

