/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.mendingremover;

import com.mojang.logging.LogUtils;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.trading.MerchantOffer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import org.slf4j.Logger;

@Mod(value="mendingremover")
public final class MendingRemover {
    public static final String MODID = "mendingremover";
    private static final Logger LOGGER = LogUtils.getLogger();

    public MendingRemover(IEventBus modBus, ModContainer modContainer) {
        modBus.addListener(this::onBuildCreative);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() != VillagerProfession.LIBRARIAN) {
            return;
        }
        for (int level = 1; level <= 5; ++level) {
            List trades = (List)event.getTrades().get(level);
            if (trades == null) continue;
            Iterator it = trades.iterator();
            while (it.hasNext()) {
                VillagerTrades.ItemListing listing = (VillagerTrades.ItemListing)it.next();
                try {
                    ItemStack result;
                    MerchantOffer offer = listing.getOffer(null, RandomSource.create());
                    if (offer == null || !(result = offer.getResult()).is(Items.ENCHANTED_BOOK) || !MendingRemover.hasMendingAny(result)) continue;
                    it.remove();
                    LOGGER.info("Removed Mending book trade (Librarian L{}).", (Object)level);
                }
                catch (Exception exception) {}
            }
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack right = event.getRight();
        if (right.is(Items.ENCHANTED_BOOK) && MendingRemover.hasMendingAny(right)) {
            event.setCanceled(true);
            LOGGER.debug("Blocked anvil operation with Mending book");
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        MendingRemover.removeMendingFromInventory(event.getEntity());
    }

    public void onBuildCreative(BuildCreativeModeTabContentsEvent event) {
        for (ItemStack stack : event.getParentEntries()) {
            if (!stack.is(Items.ENCHANTED_BOOK) || !MendingRemover.hasMendingAny(stack)) continue;
            event.remove(stack, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
        }
        for (ItemStack stack : event.getSearchEntries()) {
            if (!stack.is(Items.ENCHANTED_BOOK) || !MendingRemover.hasMendingAny(stack)) continue;
            event.remove(stack, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        }
    }

    @SubscribeEvent
    public void onLivingTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.tickCount % 200 == 0) {
                MendingRemover.removeMendingFromInventory(player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerOpenContainer(PlayerContainerEvent.Open event) {
        Player player = event.getEntity();
        AbstractContainerMenu container = event.getContainer();
        MendingRemover.removeMendingFromInventory(player);
        for (int i = 0; i < container.slots.size(); ++i) {
            Slot slot = (Slot)container.slots.get(i);
            ItemStack stack = slot.getItem();
            if (!MendingRemover.hasMendingAny(stack)) continue;
            MendingRemover.stripMending(stack);
            if (MendingRemover.isOnlyMending(stack)) {
                slot.set(ItemStack.EMPTY);
            }
            LOGGER.debug("Removed Mending from container slot {}", (Object)i);
        }
    }

    @SubscribeEvent
    public void onItemFished(ItemFishedEvent event) {
        NonNullList drops = event.getDrops();
        if (drops.isEmpty()) {
            return;
        }
        ItemStack caught = (ItemStack)drops.get(0);
        if (MendingRemover.hasMendingAny(caught)) {
            MendingRemover.stripMending(caught);
            if (MendingRemover.isOnlyMending(caught)) {
                drops.clear();
            }
            LOGGER.debug("Removed Mending book from fishing loot");
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingIncomingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            MendingRemover.removeMendingFromInventory(player);
        }
    }

    private static void removeMendingFromInventory(Player player) {
        Inventory inv = player.getInventory();
        boolean removed = false;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !MendingRemover.hasMendingAny(stack)) continue;
            MendingRemover.stripMending(stack);
            if (MendingRemover.isOnlyMending(stack)) {
                inv.setItem(i, ItemStack.EMPTY);
            }
            removed = true;
        }
        if (removed) {
            LOGGER.debug("Removed Mending from {}'s inventory", (Object)player.getName().getString());
        }
    }

    private static boolean hasMendingAny(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        ItemEnchantments ench = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments stored = (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        return MendingRemover.containsMending(ench) || MendingRemover.containsMending(stored);
    }

    private static boolean isOnlyMending(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        ItemEnchantments ench = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments stored = (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        boolean anyNormal = !ench.isEmpty();
        boolean anyStored = !stored.isEmpty();
        boolean onlyMendingNormal = MendingRemover.onlyMending(ench);
        boolean onlyMendingStored = MendingRemover.onlyMending(stored);
        if (anyNormal && !anyStored) {
            return onlyMendingNormal;
        }
        if (!anyNormal && anyStored) {
            return onlyMendingStored;
        }
        if (!anyNormal && !anyStored) {
            return false;
        }
        return onlyMendingNormal && onlyMendingStored;
    }

    private static boolean containsMending(ItemEnchantments list) {
        if (list.isEmpty()) {
            return false;
        }
        AtomicBoolean found = new AtomicBoolean(false);
        list.entrySet().forEach(e -> {
            Holder h = (Holder)e.getKey();
            if (h.is(Enchantments.MENDING)) {
                found.set(true);
            }
        });
        return found.get();
    }

    private static boolean onlyMending(ItemEnchantments list) {
        if (list.isEmpty()) {
            return false;
        }
        AtomicBoolean found = new AtomicBoolean(false);
        AtomicBoolean only = new AtomicBoolean(true);
        list.entrySet().forEach(e -> {
            found.set(true);
            Holder h = (Holder)e.getKey();
            if (!h.is(Enchantments.MENDING)) {
                only.set(false);
            }
        });
        return found.get() && only.get();
    }

    private static void stripMending(ItemStack stack) {
        ItemEnchantments stored;
        ItemEnchantments.Mutable mutable;
        ItemEnchantments ench = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        if (!ench.isEmpty()) {
            mutable = new ItemEnchantments.Mutable(ench);
            mutable.removeIf(h -> h.is(Enchantments.MENDING));
            if (mutable.keySet().isEmpty()) {
                stack.remove(DataComponents.ENCHANTMENTS);
            } else {
                stack.set(DataComponents.ENCHANTMENTS, (Object)mutable.toImmutable());
            }
        }
        if (!(stored = (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).isEmpty()) {
            mutable = new ItemEnchantments.Mutable(stored);
            mutable.removeIf(h -> h.is(Enchantments.MENDING));
            if (mutable.keySet().isEmpty()) {
                stack.remove(DataComponents.STORED_ENCHANTMENTS);
            } else {
                stack.set(DataComponents.STORED_ENCHANTMENTS, (Object)mutable.toImmutable());
            }
        }
        ItemEnchantments afterEnch = (ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments afterStored = (ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        if (afterEnch.isEmpty() && afterStored.isEmpty()) {
            stack.remove(DataComponents.REPAIR_COST);
        }
    }
}

