/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.mendingremover.mixins;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class}, priority=1001)
public abstract class ItemStackMixin {
    @Inject(method={"hasFoil"}, at={@At(value="HEAD")}, cancellable=true)
    private void mendingremover$hideFoilIfOnlyMending(CallbackInfoReturnable<Boolean> cir) {
        boolean hasAnyMending;
        ItemStack self = (ItemStack)this;
        if (self.isEmpty()) {
            return;
        }
        ItemEnchantments normal = (ItemEnchantments)self.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        ItemEnchantments stored = (ItemEnchantments)self.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        boolean hasAnyNonMending = ItemStackMixin.hasAnyNonMending(normal) || ItemStackMixin.hasAnyNonMending(stored);
        boolean bl = hasAnyMending = ItemStackMixin.hasMending(normal) || ItemStackMixin.hasMending(stored);
        if (hasAnyMending && !hasAnyNonMending) {
            cir.setReturnValue((Object)false);
        }
    }

    private static boolean hasAnyNonMending(ItemEnchantments list) {
        if (list.isEmpty()) {
            return false;
        }
        AtomicBoolean res = new AtomicBoolean(false);
        list.entrySet().forEach(e -> {
            Holder h = (Holder)e.getKey();
            if (!h.is(Enchantments.MENDING)) {
                res.set(true);
            }
        });
        return res.get();
    }

    private static boolean hasMending(ItemEnchantments list) {
        if (list.isEmpty()) {
            return false;
        }
        AtomicBoolean res = new AtomicBoolean(false);
        list.entrySet().forEach(e -> {
            Holder h = (Holder)e.getKey();
            if (h.is(Enchantments.MENDING)) {
                res.set(true);
            }
        });
        return res.get();
    }
}

