/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.chunk.internal.mixin.mixins.common.vanilla;

import com.falsepattern.chunk.internal.DataRegistryImpl;
import cpw.mods.fml.common.FMLLog;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AnvilChunkLoader.class})
public abstract class AnvilChunkLoaderMixin {
    @Inject(method={"writeChunkToNBT"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void writeChunkToNBT(Chunk chunk, World world, NBTTagCompound nbt, CallbackInfo ci) {
        nbt.func_74774_a("V", (byte)1);
        nbt.func_74768_a("xPos", chunk.field_76635_g);
        nbt.func_74768_a("zPos", chunk.field_76647_h);
        nbt.func_74772_a("LastUpdate", world.func_82737_E());
        nbt.func_74757_a("TerrainPopulated", chunk.field_76646_k);
        nbt.func_74772_a("InhabitedTime", chunk.field_111204_q);
        this.writeSubChunks(chunk, nbt);
        this.writeCustomData(chunk, nbt);
        this.writeEntities(chunk, world, nbt);
        ci.cancel();
    }

    @Inject(method={"readChunkFromNBT"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void readChunkFromNBT(World world, NBTTagCompound nbt, CallbackInfoReturnable<Chunk> cir) {
        int x = nbt.func_74762_e("xPos");
        int z = nbt.func_74762_e("zPos");
        Chunk chunk = new Chunk(world, x, z);
        chunk.field_76646_k = nbt.func_74767_n("TerrainPopulated");
        chunk.field_111204_q = nbt.func_74763_f("InhabitedTime");
        this.readSubChunks(chunk, nbt);
        this.readCustomData(chunk, nbt);
        cir.setReturnValue((Object)chunk);
    }

    private void readCustomData(Chunk chunk, NBTTagCompound nbt) {
        DataRegistryImpl.readChunkFromNBT(chunk, nbt);
    }

    private void readSubChunks(Chunk chunk, NBTTagCompound nbt) {
        NBTTagList subChunksNBT = nbt.func_150295_c("Sections", 10);
        int segments = 16;
        ExtendedBlockStorage[] subChunkList = new ExtendedBlockStorage[segments];
        for (int k = 0; k < subChunksNBT.func_74745_c(); ++k) {
            NBTTagCompound subChunkNBT = subChunksNBT.func_150305_b(k);
            byte yLevel = subChunkNBT.func_74771_c("Y");
            ExtendedBlockStorage subChunk = new ExtendedBlockStorage(yLevel << 4, !chunk.field_76637_e.field_73011_w.field_76576_e);
            DataRegistryImpl.readSubChunkFromNBT(chunk, subChunk, subChunkNBT);
            subChunk.func_76672_e();
            subChunkList[yLevel] = subChunk;
        }
        chunk.func_76602_a(subChunkList);
    }

    private void writeCustomData(Chunk chunk, NBTTagCompound nbt) {
        DataRegistryImpl.writeChunkToNBT(chunk, nbt);
    }

    private void writeSubChunks(Chunk chunk, NBTTagCompound nbt) {
        ExtendedBlockStorage[] subChunks = chunk.func_76587_i();
        NBTTagList subChunksNBT = new NBTTagList();
        for (ExtendedBlockStorage subChunk : subChunks) {
            if (subChunk == null) continue;
            NBTTagCompound subChunkNBT = new NBTTagCompound();
            subChunkNBT.func_74774_a("Y", (byte)(subChunk.func_76662_d() >> 4 & 0xFF));
            DataRegistryImpl.writeSubChunkToNBT(chunk, subChunk, subChunkNBT);
            subChunksNBT.func_74742_a((NBTBase)subChunkNBT);
        }
        nbt.func_74782_a("Sections", (NBTBase)subChunksNBT);
    }

    private void writeEntities(Chunk chunk, World world, NBTTagCompound nbt) {
        chunk.field_76644_m = false;
        NBTTagList entities = new NBTTagList();
        for (int i = 0; i < chunk.field_76645_j.length; ++i) {
            for (Object o : chunk.field_76645_j[i]) {
                Entity entity = (Entity)o;
                NBTTagCompound entityNBT = new NBTTagCompound();
                try {
                    if (!entity.func_70039_c(entityNBT)) continue;
                    chunk.field_76644_m = true;
                    entities.func_74742_a((NBTBase)entityNBT);
                }
                catch (Exception e) {
                    FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"An Entity type %s has thrown an exception trying to write state. It will not persist. Report this to the mod author", (Object[])new Object[]{entity.getClass().getName()});
                }
            }
        }
        nbt.func_74782_a("Entities", (NBTBase)entities);
        NBTTagList tileEntities = new NBTTagList();
        for (Object o : chunk.field_150816_i.values()) {
            TileEntity tileentity = (TileEntity)o;
            NBTTagCompound tileEntityNBT = new NBTTagCompound();
            try {
                tileentity.func_145841_b(tileEntityNBT);
                tileEntities.func_74742_a((NBTBase)tileEntityNBT);
            }
            catch (Exception e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"A TileEntity type %s has throw an exception trying to write state. It will not persist. Report this to the mod author", (Object[])new Object[]{tileentity.getClass().getName()});
            }
        }
        nbt.func_74782_a("TileEntities", (NBTBase)tileEntities);
        List pendingUpdates = world.func_72920_a(chunk, false);
        if (pendingUpdates != null) {
            long k = world.func_82737_E();
            NBTTagList tileTicks = new NBTTagList();
            for (Object o : pendingUpdates) {
                NextTickListEntry update = (NextTickListEntry)o;
                NBTTagCompound updateNBT = new NBTTagCompound();
                updateNBT.func_74768_a("i", Block.func_149682_b((Block)update.func_151351_a()));
                updateNBT.func_74768_a("x", update.field_77183_a);
                updateNBT.func_74768_a("y", update.field_77181_b);
                updateNBT.func_74768_a("z", update.field_77182_c);
                updateNBT.func_74768_a("t", (int)(update.field_77180_e - k));
                updateNBT.func_74768_a("p", update.field_82754_f);
                tileTicks.func_74742_a((NBTBase)updateNBT);
            }
            nbt.func_74782_a("TileTicks", (NBTBase)tileTicks);
        }
    }
}

