/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.chunk.internal.mixin.mixins.common.vanilla;

import com.falsepattern.chunk.internal.DataRegistryImpl;
import com.falsepattern.chunk.internal.mixin.helpers.LockHelper;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S21PacketChunkData;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={S21PacketChunkData.class})
public abstract class S21PacketChunkDataMixin {
    @Shadow(aliases={"field_149286_i"}, remap=false)
    private static byte[] buffer;
    @Shadow(remap=false)
    private Semaphore deflateGate;
    @Shadow(aliases={"field_149284_a"}, remap=false)
    private int xPosition;
    @Shadow(aliases={"field_149282_b"}, remap=false)
    private int zPosition;
    @Shadow(aliases={"field_149283_c"}, remap=false)
    private int subChunkMask;
    @Shadow(aliases={"field_149281_e"}, remap=false)
    private byte[] deflatedData;
    @Shadow(aliases={"field_149278_f"}, remap=false)
    private byte[] data;
    @Shadow(aliases={"field_149279_g"}, remap=false)
    private boolean forceUpdate;
    @Shadow(aliases={"field_149285_h"}, remap=false)
    private int deflatedSize;

    @Shadow(remap=false)
    protected abstract void deflate();

    @Overwrite
    public static int func_149275_c() {
        return DataRegistryImpl.maxPacketSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public static S21PacketChunkData.Extracted func_149269_a(Chunk chunk, boolean forceUpdate, int subChunkMask) {
        ExtendedBlockStorage[] subChunks = chunk.func_76587_i();
        S21PacketChunkData.Extracted extracted = new S21PacketChunkData.Extracted();
        if (forceUpdate) {
            chunk.field_76642_o = true;
        }
        for (int i = 0; i < subChunks.length; ++i) {
            if (subChunks[i] == null || forceUpdate && subChunks[i].func_76663_a() || (subChunkMask & 1 << i) == 0) continue;
            extracted.field_150280_b |= 1 << i;
        }
        while (!LockHelper.bufferLockS21PacketChunkData.tryLock()) {
            Thread.yield();
        }
        try {
            if (buffer.length < DataRegistryImpl.maxPacketSize()) {
                buffer = new byte[DataRegistryImpl.maxPacketSize()];
            }
            int length = DataRegistryImpl.writeToBuffer(chunk, extracted.field_150280_b, forceUpdate, buffer);
            extracted.field_150282_a = new byte[length];
            System.arraycopy(buffer, 0, extracted.field_150282_a, 0, length);
        }
        finally {
            LockHelper.bufferLockS21PacketChunkData.unlock();
        }
        return extracted;
    }

    @Overwrite
    public void func_148840_b(PacketBuffer data) {
        if (this.deflatedData == null) {
            this.deflateGate.acquireUninterruptibly();
            try {
                if (this.deflatedData == null) {
                    this.deflate();
                }
            }
            finally {
                this.deflateGate.release();
            }
        }
        data.writeInt(this.xPosition);
        data.writeInt(this.zPosition);
        data.writeBoolean(this.forceUpdate);
        data.writeShort((int)((short)(this.subChunkMask & 0xFFFF)));
        data.writeInt(this.data.length);
        data.writeInt(this.deflatedSize);
        data.writeBytes(this.deflatedData, 0, this.deflatedSize);
    }

    @Overwrite
    public void func_148837_a(PacketBuffer data) throws IOException {
        this.xPosition = data.readInt();
        this.zPosition = data.readInt();
        this.forceUpdate = data.readBoolean();
        this.subChunkMask = data.readShort() & 0xFFFF;
        this.data = new byte[data.readInt()];
        this.deflatedSize = data.readInt();
        if (buffer.length < this.deflatedSize) {
            buffer = new byte[this.deflatedSize];
        }
        data.readBytes(buffer, 0, this.deflatedSize);
        Inflater inflater = new Inflater();
        inflater.setInput(buffer, 0, this.deflatedSize);
        try {
            inflater.inflate(this.data);
        }
        catch (DataFormatException dfe) {
            throw new IOException("Bad compressed data format");
        }
        finally {
            inflater.end();
        }
    }
}

