/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.chunk.internal.vanilla;

import com.falsepattern.chunk.api.ArrayUtil;
import com.falsepattern.chunk.api.DataManager;
import com.falsepattern.chunk.internal.vanilla.VanillaManager;
import java.nio.ByteBuffer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.chunk.Chunk;
import org.jetbrains.annotations.NotNull;

public class BiomeManager
extends VanillaManager
implements DataManager.PacketDataManager,
DataManager.ChunkDataManager {
    public static final int BYTES_PER_CHUNK = 256;

    @Override
    public String id() {
        return "biome";
    }

    @Override
    public int maxPacketSize() {
        return 256;
    }

    @Override
    public void writeToBuffer(@NotNull Chunk chunk, int subChunkMask, boolean forceUpdate, @NotNull ByteBuffer buffer) {
        if (forceUpdate) {
            buffer.put(chunk.func_76605_m());
        }
    }

    @Override
    public void readFromBuffer(@NotNull Chunk chunk, int subChunkMask, boolean forceUpdate, @NotNull ByteBuffer buffer) {
        if (forceUpdate) {
            buffer.get(chunk.func_76605_m());
        }
    }

    @Override
    public boolean chunkPrivilegedAccess() {
        return true;
    }

    @Override
    public void writeChunkToNBT(@NotNull Chunk chunk, @NotNull NBTTagCompound nbt) {
        nbt.func_74773_a("Biomes", chunk.func_76605_m());
    }

    @Override
    public void readChunkFromNBT(@NotNull Chunk chunk, @NotNull NBTTagCompound nbt) {
        if (nbt.func_150297_b("Biomes", 7)) {
            chunk.func_76616_a(nbt.func_74770_j("Biomes"));
        }
    }

    @Override
    public void cloneChunk(Chunk from, Chunk to) {
        to.func_76616_a(ArrayUtil.copyArray(from.func_76605_m(), to.func_76605_m()));
    }
}

