/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.chunk.internal.vanilla;

import com.falsepattern.chunk.api.ArrayUtil;
import com.falsepattern.chunk.api.DataManager;
import com.falsepattern.chunk.internal.vanilla.VanillaManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class BlockIDManager
extends VanillaManager
implements DataManager.PacketDataManager,
DataManager.BlockPacketDataManager,
DataManager.SubChunkDataManager {
    private static final int LSB_BYTES_PER_SUBCHUNK = 4096;
    private static final int MSB_BYTES_PER_SUBCHUNK = 2048;
    private static final int HEADER_SIZE = 2;

    @Override
    public String id() {
        return "blockid";
    }

    @Override
    public int maxPacketSize() {
        return 98306;
    }

    @Override
    public void writeToBuffer(Chunk chunk, int subChunkMask, boolean forceUpdate, ByteBuffer buffer) {
        ExtendedBlockStorage[] subChunks = chunk.func_76587_i();
        int currentPos = buffer.position();
        buffer.putShort((short)0);
        int msbMask = 0;
        for (int i = 0; i < subChunks.length; ++i) {
            if ((subChunkMask & 1 << i) == 0) continue;
            ExtendedBlockStorage subChunk = subChunks[i];
            byte[] lsb = subChunk.func_76658_g();
            NibbleArray msb = subChunk.func_76660_i();
            buffer.put(lsb);
            if (msb == null) continue;
            msbMask |= 1 << i;
            buffer.put(msb.field_76585_a);
        }
        int endPos = buffer.position();
        buffer.position(currentPos);
        buffer.putShort((short)msbMask);
        buffer.position(endPos);
    }

    @Override
    public void readFromBuffer(Chunk chunk, int subChunkMask, boolean forceUpdate, ByteBuffer buffer) {
        ExtendedBlockStorage[] subChunks = chunk.func_76587_i();
        int msbMask = buffer.getShort() & 0xFFFF;
        for (int i = 0; i < subChunks.length; ++i) {
            ExtendedBlockStorage subChunk = subChunks[i];
            if ((subChunkMask & 1 << i) == 0 || subChunk == null) continue;
            buffer.get(subChunk.func_76658_g());
            if ((msbMask & 1 << i) != 0) {
                NibbleArray msb = subChunk.func_76660_i();
                if (msb == null) {
                    subChunk.func_76667_m();
                }
                buffer.get(subChunk.func_76660_i().field_76585_a);
                continue;
            }
            subChunk.func_76673_a(null);
        }
    }

    @Override
    public boolean subChunkPrivilegedAccess() {
        return true;
    }

    @Override
    public void writeSubChunkToNBT(Chunk chunk, ExtendedBlockStorage subChunk, NBTTagCompound nbt) {
        nbt.func_74773_a("Blocks", subChunk.func_76658_g());
        if (subChunk.func_76660_i() != null) {
            nbt.func_74773_a("Add", subChunk.func_76660_i().field_76585_a);
        }
    }

    @Override
    public void readSubChunkFromNBT(Chunk chunk, ExtendedBlockStorage subChunk, NBTTagCompound nbt) {
        subChunk.func_76664_a(nbt.func_74770_j("Blocks"));
        if (nbt.func_150297_b("Add", 7)) {
            subChunk.func_76673_a(new NibbleArray(nbt.func_74770_j("Add"), 4));
        }
    }

    @Override
    public void cloneSubChunk(Chunk fromChunk, ExtendedBlockStorage from, ExtendedBlockStorage to) {
        to.func_76664_a(ArrayUtil.copyArray(from.func_76658_g(), to.func_76658_g()));
        to.func_76673_a(ArrayUtil.copyArray(from.func_76660_i(), to.func_76660_i()));
    }

    @Override
    public void writeBlockToPacket(Chunk chunk, int x, int y, int z, S23PacketBlockChange packet) {
    }

    @Override
    public void readBlockFromPacket(Chunk chunk, int x, int y, int z, S23PacketBlockChange packet) {
    }

    @Override
    public void writeBlockPacketToBuffer(S23PacketBlockChange packet, PacketBuffer buffer) throws IOException {
        buffer.writeShort(Block.func_149682_b((Block)packet.field_148883_d) & 0xFFF);
    }

    @Override
    public void readBlockPacketFromBuffer(S23PacketBlockChange packet, PacketBuffer buffer) throws IOException {
        packet.field_148883_d = Block.func_149729_e((int)(buffer.readUnsignedShort() & 0xFFF));
    }
}

