/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import dev.rndmorris.salisarcana.SalisArcana;
import dev.rndmorris.salisarcana.common.BehaviorDispensePrimalArrow;
import dev.rndmorris.salisarcana.common.CustomResearch;
import dev.rndmorris.salisarcana.common.DisenchantFocusUpgrade;
import dev.rndmorris.salisarcana.common.blocks.CustomBlocks;
import dev.rndmorris.salisarcana.common.commands.ArcanaCommandBase;
import dev.rndmorris.salisarcana.common.commands.CreateNodeCommand;
import dev.rndmorris.salisarcana.common.commands.ForgetAspectCommand;
import dev.rndmorris.salisarcana.common.commands.ForgetResearchCommand;
import dev.rndmorris.salisarcana.common.commands.ForgetScannedCommand;
import dev.rndmorris.salisarcana.common.commands.HelpCommand;
import dev.rndmorris.salisarcana.common.commands.InfusionSymmetryCommand;
import dev.rndmorris.salisarcana.common.commands.ListResearchCommand;
import dev.rndmorris.salisarcana.common.commands.PrerequisitesCommand;
import dev.rndmorris.salisarcana.common.commands.UpdateNodeCommand;
import dev.rndmorris.salisarcana.common.commands.UpgradeFocusCommand;
import dev.rndmorris.salisarcana.common.compat.ModCompat;
import dev.rndmorris.salisarcana.common.item.PlaceholderItem;
import dev.rndmorris.salisarcana.common.recipes.CustomRecipes;
import dev.rndmorris.salisarcana.config.SalisConfig;
import dev.rndmorris.salisarcana.config.group.ConfigFeatures;
import dev.rndmorris.salisarcana.config.settings.CommandSettings;
import dev.rndmorris.salisarcana.lib.BlockAiryBucketInterceptor;
import dev.rndmorris.salisarcana.lib.CrucibleHeatLogic;
import dev.rndmorris.salisarcana.lib.KnowItAll;
import dev.rndmorris.salisarcana.lib.ObfuscationInfo;
import dev.rndmorris.salisarcana.lib.R;
import dev.rndmorris.salisarcana.lib.WandHelper;
import dev.rndmorris.salisarcana.network.NetworkHandler;
import dev.rndmorris.salisarcana.notifications.StartupNotifications;
import dev.rndmorris.salisarcana.notifications.Updater;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.block.BlockDispenser;
import net.minecraft.command.ICommand;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.common.FishingHooks;
import net.minecraftforge.common.MinecraftForge;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.ai.interact.AIFish;
import thaumcraft.common.items.equipment.ItemPrimalCrusher;

public class CommonProxy {
    public CommonProxy() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void preInit(FMLPreInitializationEvent event) {
        if (SalisConfig.features.enableFocusDisenchanting.isEnabled()) {
            DisenchantFocusUpgrade.initialize();
        }
        ModCompat.preInit();
        CustomBlocks.registerBlocks();
        PlaceholderItem.registerPlaceholders();
        if (SalisConfig.thaum.primalArrowsCanBeFiredFromDispensers.isEnabled()) {
            BlockDispenser.dispenseBehaviorRegistry.putObject((Object)ConfigItems.itemPrimalArrow, (Object)new BehaviorDispensePrimalArrow());
        }
        if (SalisConfig.bugfixes.useForgeFishingLists.isEnabled()) {
            this.fixGolemFishingLists();
        }
        if (SalisConfig.features.heatSourceOreDict.isEnabled()) {
            CrucibleHeatLogic.registerOreDictName();
        }
        this.updateHarvestLevels();
        FMLCommonHandler.instance().bus().register((Object)new Updater());
        FMLCommonHandler.instance().bus().register((Object)new StartupNotifications());
        MinecraftForge.EVENT_BUS.register((Object)KnowItAll.EVENT_COLLECTOR);
        if (SalisConfig.bugfixes.preventBlockAiryFluidReplacement.isEnabled()) {
            MinecraftForge.EVENT_BUS.register((Object)new BlockAiryBucketInterceptor());
        }
    }

    private void updateHarvestLevels() {
        ConfigFeatures features = SalisConfig.features;
        String harvestLevelName = ObfuscationInfo.HARVEST_LEVEL.getName();
        if (features.thaumiumHarvestLevel.isEnabled()) {
            R toolMatThaumium = new R(ThaumcraftApi.toolMatThaumium);
            toolMatThaumium.set(harvestLevelName, features.thaumiumHarvestLevel.getValue());
        }
        if (features.elementalHarvestLevel.isEnabled()) {
            R toolMatElemental = new R(ThaumcraftApi.toolMatElemental);
            toolMatElemental.set(harvestLevelName, features.elementalHarvestLevel.getValue());
        }
        if (features.voidHarvestLevel.isEnabled()) {
            R toolMatVoid = new R(ThaumcraftApi.toolMatVoid);
            toolMatVoid.set(harvestLevelName, features.voidHarvestLevel.getValue());
        }
        if (features.crusherHarvestLevel.isEnabled()) {
            R material = new R(ItemPrimalCrusher.material);
            material.set(harvestLevelName, features.crusherHarvestLevel.getValue());
            ConfigItems.itemPrimalCrusher.setHarvestLevel("pickaxe", features.crusherHarvestLevel.getValue());
            ConfigItems.itemPrimalCrusher.setHarvestLevel("shovel", features.crusherHarvestLevel.getValue());
        }
    }

    public void init(FMLInitializationEvent event) {
        ModCompat.init();
        CustomRecipes.registerRecipes();
        NetworkHandler.init();
    }

    public void postInit(FMLPostInitializationEvent event) {
        CustomRecipes.registerRecipesPostInit();
        CustomResearch.init();
        WandHelper.loadWandParts();
    }

    public void serverStarting(FMLServerStartingEvent event) {
        this.maybeRegister(event, SalisConfig.commands.createNode, CreateNodeCommand::new);
        this.maybeRegister(event, SalisConfig.commands.forgetResearch, ForgetResearchCommand::new);
        this.maybeRegister(event, SalisConfig.commands.forgetScanned, ForgetScannedCommand::new);
        this.maybeRegister(event, SalisConfig.commands.forgetAspects, ForgetAspectCommand::new);
        this.maybeRegister(event, SalisConfig.commands.help, HelpCommand::new);
        this.maybeRegister(event, SalisConfig.commands.infusionSymmetry, InfusionSymmetryCommand::new);
        this.maybeRegister(event, SalisConfig.commands.prerequisites, PrerequisitesCommand::new);
        this.maybeRegister(event, SalisConfig.commands.playerResearch, ListResearchCommand::new);
        this.maybeRegister(event, SalisConfig.commands.updateNode, UpdateNodeCommand::new);
        this.maybeRegister(event, SalisConfig.commands.upgradeFocus, UpgradeFocusCommand::new);
    }

    private void maybeRegister(FMLServerStartingEvent event, CommandSettings settings, Supplier<ArcanaCommandBase<?>> init) {
        if (settings.isEnabled()) {
            event.registerServerCommand((ICommand)init.get());
        }
    }

    public boolean isSingleplayerClient() {
        return false;
    }

    public World getFakePlayerWorld() {
        return MinecraftServer.getServer().worldServerForDimension(0);
    }

    private void fixGolemFishingLists() {
        try {
            R fishingHooks = new R(FishingHooks.class);
            R aiFish = new R(AIFish.class);
            aiFish.set("LOOTCRAP", fishingHooks.get("junk", ArrayList.class));
            aiFish.set("LOOTRARE", fishingHooks.get("treasure", ArrayList.class));
            aiFish.set("LOOTFISH", fishingHooks.get("fish", ArrayList.class));
        }
        catch (RuntimeException e) {
            SalisArcana.LOG.error("An error occurred updating golem fishing lists.", (Throwable)e);
        }
    }
}

