/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import dev.rndmorris.salisarcana.SalisArcana;
import dev.rndmorris.salisarcana.config.SalisConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.inventory.SlotMerchantResult;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ScanResult;
import thaumcraft.client.lib.ClientTickEventsFML;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.playerdata.PacketScannedToServer;
import thaumcraft.common.lib.research.ScanManager;

public class ThaumicInventoryScanner {
    private static int SCAN_TICKS = -1;
    private static final int SOUND_TICKS = 5;
    private static final int INVENTORY_PLAYER_X = 26;
    private static final int INVENTORY_PLAYER_Y = 8;
    private static final int INVENTORY_PLAYER_WIDTH = 52;
    private static final int INVENTORY_PLAYER_HEIGHT = 70;
    private boolean isValidSlot = false;
    private Item thaumometer;
    private Slot hoveringSlot;
    private Slot lastHoveredSlot;
    private int ticksHovered = 0;
    private ClientTickEventsFML effectRenderer;
    private ScanResult currentScan = null;
    private boolean isHoveringOverPlayer;

    static int getScanTicks() {
        if (SCAN_TICKS < 0) {
            SCAN_TICKS = (SalisConfig.features.thaumometerDuration.getValue() + 5) * 2;
        }
        return SCAN_TICKS;
    }

    public void init(FMLInitializationEvent event) {
        this.effectRenderer = new ClientTickEventsFML();
    }

    public void postInit(FMLPostInitializationEvent event) {
        this.thaumometer = GameRegistry.findItem((String)"Thaumcraft", (String)"ItemThaumometer");
    }

    private void simulateScan(EntityPlayer player) {
        ScanResult result = new ScanResult(2, 0, 0, (Entity)player, "");
        if (this.isHoveringOverPlayer && ScanManager.isValidScanTarget((EntityPlayer)player, (ScanResult)result, (String)"@")) {
            this.currentScan = result;
            this.isValidSlot = true;
            return;
        }
        if (this.hoveringSlot != null && this.hoveringSlot.getStack() != null) {
            result = new ScanResult(1, Item.getIdFromItem((Item)this.hoveringSlot.getStack().getItem()), this.hoveringSlot.getStack().getItemDamage(), null, "");
            if (this.hoveringSlot.canTakeStack(player) && !(this.hoveringSlot instanceof SlotCrafting) && !(this.hoveringSlot instanceof SlotMerchantResult) && ScanManager.isValidScanTarget((EntityPlayer)player, (ScanResult)result, (String)"@") && !ScanManager.getScanAspects((ScanResult)result, (World)Minecraft.getMinecraft().theWorld.provider.worldObj).aspects.isEmpty()) {
                this.currentScan = result;
                this.isValidSlot = true;
                return;
            }
        }
        this.cancel();
    }

    private boolean notHoldingThaumometer(EntityPlayer player) {
        return player == null || player.inventory.getItemStack() == null || player.inventory.getItemStack().getItem() != this.thaumometer;
    }

    private void cancel() {
        this.ticksHovered = 0;
        this.currentScan = null;
        this.isValidSlot = false;
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent ignored) {
        if (!SalisArcana.isServerSideInstalled) {
            return;
        }
        Minecraft mc = Minecraft.getMinecraft();
        EntityClientPlayerMP player = mc.thePlayer;
        if (this.notHoldingThaumometer((EntityPlayer)player)) {
            this.cancel();
            return;
        }
        if (this.hoveringSlot == this.lastHoveredSlot) {
            if (this.isValidSlot) {
                ++this.ticksHovered;
                this.playScanningSoundTick((EntityPlayer)player);
                if (this.ticksHovered >= ThaumicInventoryScanner.getScanTicks()) {
                    this.tryCompleteScan((EntityPlayer)player);
                }
            } else if (this.isHoveringOverPlayer) {
                this.cancel();
                this.simulateScan((EntityPlayer)player);
            }
        } else {
            this.cancel();
            this.simulateScan((EntityPlayer)player);
        }
        this.lastHoveredSlot = this.hoveringSlot;
    }

    private void tryCompleteScan(EntityPlayer player) {
        if (ScanManager.completeScan((EntityPlayer)player, (ScanResult)this.currentScan, (String)"@")) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketScannedToServer(this.currentScan, player, "@"));
        }
        this.cancel();
    }

    private void playScanningSoundTick(EntityPlayer entityPlayer) {
        if (this.ticksHovered > 5 && this.ticksHovered % 2 == 0) {
            entityPlayer.worldObj.playSound(entityPlayer.posX, entityPlayer.posY, entityPlayer.posZ, "thaumcraft:cameraticks", 0.2f, 0.45f + entityPlayer.worldObj.rand.nextFloat() * 0.1f, false);
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (SalisArcana.isServerSideInstalled && event.itemStack.getItem() == this.thaumometer) {
            event.toolTip.add("\u00a76" + I18n.format((String)"salisarcana:tcinventoryscan.thaumometerTooltip", (Object[])new Object[0]));
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                String[] lines;
                for (String line : lines = I18n.format((String)"salisarcana:tcinventoryscan.thaumometerTooltipMore", (Object[])new Object[0]).split("\\\\n")) {
                    event.toolTip.add("\u00a73" + line);
                }
            }
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (SalisArcana.isServerSideInstalled && event.gui instanceof GuiContainer) {
            boolean stackExists;
            Minecraft mc = Minecraft.getMinecraft();
            EntityClientPlayerMP player = mc.thePlayer;
            if (this.notHoldingThaumometer((EntityPlayer)player)) {
                return;
            }
            this.isHoveringOverPlayer = this.isHoveringPlayer((GuiContainer)event.gui, event.mouseX, event.mouseY);
            this.hoveringSlot = ((GuiContainer)event.gui).getSlotAtPosition(event.mouseX, event.mouseY);
            boolean bl = stackExists = this.hoveringSlot != null && this.hoveringSlot.getStack() != null;
            if (!this.isHoveringOverPlayer && !stackExists) {
                return;
            }
            if (this.currentScan != null && stackExists) {
                this.renderScanningProgress(event.gui, event.mouseX, event.mouseY, (float)this.ticksHovered / (float)ThaumicInventoryScanner.getScanTicks());
            } else if (!this.isHoveringOverPlayer) {
                event.gui.renderToolTip(this.hoveringSlot.getStack(), event.mouseX, event.mouseY);
                this.effectRenderer.renderAspectsInGui((GuiContainer)event.gui, (EntityPlayer)player);
            } else {
                this.renderPlayerAspects(event.gui, event.mouseX, event.mouseY);
            }
        }
    }

    public void renderPlayerAspects(GuiScreen gui, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        int shiftX = Thaumcraft.instance.aspectShift ? -16 : -8;
        int shiftY = Thaumcraft.instance.aspectShift ? -16 : -8;
        int x = mouseX + 17;
        int y = mouseY + 7 - 33;
        EntityClientPlayerMP entityPlayer = FMLClientHandler.instance().getClientPlayerEntity();
        AspectList aspectList = ScanManager.generateEntityAspects((Entity)entityPlayer);
        if (aspectList != null) {
            GL11.glDisable((int)2929);
            if (aspectList.size() > 0) {
                Aspect[] sortedAspects;
                for (Aspect aspect : sortedAspects = aspectList.getAspectsSortedAmount()) {
                    if (aspect == null) continue;
                    UtilsFX.bindTexture((String)"textures/aspects/_back.png");
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glTranslatef((float)((x += 18) + shiftX - 2), (float)(y + shiftY - 2), (float)0.0f);
                    GL11.glScalef((float)1.25f, (float)1.25f, (float)0.0f);
                    UtilsFX.drawTexturedQuadFull((int)0, (int)0, (double)UtilsFX.getGuiZLevel((Gui)gui));
                    GL11.glDisable((int)3042);
                    GL11.glPopMatrix();
                    if (Thaumcraft.proxy.playerKnowledge.hasDiscoveredAspect(entityPlayer.getCommandSenderName(), aspect)) {
                        UtilsFX.drawTag((int)(x + shiftX), (int)(y + shiftY), (Aspect)aspect, (float)aspectList.getAmount(aspect), (int)0, (double)UtilsFX.getGuiZLevel((Gui)gui));
                        continue;
                    }
                    UtilsFX.bindTexture((String)"textures/aspects/_unknown.png");
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glTranslatef((float)(x + shiftX), (float)(y + shiftY), (float)0.0f);
                    UtilsFX.drawTexturedQuadFull((int)0, (int)0, (double)UtilsFX.getGuiZLevel((Gui)gui));
                    GL11.glDisable((int)3042);
                    GL11.glPopMatrix();
                }
            }
            GL11.glEnable((int)2929);
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public void renderScanningProgress(GuiScreen gui, int mouseX, int mouseY, float progress) {
        StringBuilder sb = new StringBuilder("\u00a76");
        sb.append(I18n.format((String)"salisarcana:tcinventoryscan.scanning", (Object[])new Object[0]));
        if (progress >= 0.75f) {
            sb.append("...");
        } else if (progress >= 0.5f) {
            sb.append("..");
        } else if (progress >= 0.25f) {
            sb.append(".");
        }
        GL11.glDisable((int)32826);
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        float oldZLevel = gui.zLevel;
        gui.zLevel = 300.0f;
        Minecraft.getMinecraft().fontRenderer.drawStringWithShadow(sb.toString(), mouseX, mouseY - 30, Integer.MAX_VALUE);
        gui.zLevel = oldZLevel;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        RenderHelper.enableStandardItemLighting();
        GL11.glEnable((int)32826);
    }

    public boolean isHoveringPlayer(GuiContainer gui, int mouseX, int mouseY) {
        return gui instanceof GuiInventory && mouseX >= gui.guiLeft + 26 && mouseX < gui.guiLeft + 26 + 52 && mouseY >= gui.guiTop + 8 && mouseY < gui.guiTop + 8 + 70;
    }
}

