/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common;

import com.gtnewhorizons.tcwands.api.TCWandAPI;
import com.gtnewhorizons.tcwands.api.wandinfo.WandDetails;
import com.gtnewhorizons.tcwands.api.wrappers.AbstractWandWrapper;
import dev.rndmorris.salisarcana.SalisArcana;
import dev.rndmorris.salisarcana.common.DisenchantFocusUpgrade;
import dev.rndmorris.salisarcana.common.compat.GTNHTCWandsCompat;
import dev.rndmorris.salisarcana.common.item.PlaceholderItem;
import dev.rndmorris.salisarcana.config.SalisConfig;
import dev.rndmorris.salisarcana.config.settings.CustomResearchSetting;
import dev.rndmorris.salisarcana.lib.ArrayHelper;
import dev.rndmorris.salisarcana.lib.AspectHelper;
import dev.rndmorris.salisarcana.lib.WandHelper;
import dev.rndmorris.salisarcana.lib.WandType;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;
import thaumcraft.api.wands.StaffRod;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.wands.ItemWandCasting;

public class CustomResearch {
    public static ResearchItem replaceCapsResearch;
    public static ResearchItem replaceCoreResearch;
    public static ResearchItem containerScanResearch;

    public static void init() {
        ItemWandCasting wandItem = (ItemWandCasting)ConfigItems.itemWandCasting;
        ItemStack wand = new ItemStack((Item)wandItem);
        wandItem.setRod(wand, ConfigItems.WAND_ROD_WOOD);
        wandItem.setCap(wand, ConfigItems.WAND_CAP_GOLD);
        replaceCapsResearch = CustomResearch.maybeRegister(SalisConfig.features.replaceWandCapsSettings, PlaceholderItem.capPlaceholder, CustomResearch.exampleCapRecipes());
        wandItem.setRod(wand, ConfigItems.WAND_ROD_GREATWOOD);
        wandItem.setCap(wand, ConfigItems.WAND_CAP_IRON);
        replaceCoreResearch = CustomResearch.maybeRegister(SalisConfig.features.replaceWandCoreSettings, PlaceholderItem.rodPlaceholder, CustomResearch.exampleRodRecipes());
        if (SalisConfig.features.enableFocusDisenchanting.isEnabled()) {
            DisenchantFocusUpgrade.registerResearch();
        }
        if (SalisConfig.features.nomiconDuplicateResearch.isEnabled()) {
            ResearchItem dupeResearch = ResearchCategories.getResearch((String)"RESEARCHDUPE");
            ResearchPage[] oldPages = dupeResearch.getPages();
            ResearchPage[] newPages = new ResearchPage[oldPages.length + 1];
            System.arraycopy(oldPages, 0, newPages, 0, oldPages.length);
            newPages[oldPages.length] = new ResearchPage("salisarcana:duplicate_research.extra_page");
            dupeResearch.setPages(newPages);
        }
        containerScanResearch = CustomResearch.maybeRegister(SalisConfig.features.thaumometerScanContainersResearch, Item.getItemFromBlock((Block)Blocks.chest), new IArcaneRecipe[0][]);
    }

    private static IArcaneRecipe[][] exampleCapRecipes() {
        if (!SalisConfig.features.replaceWandCapsSettings.isEnabled()) {
            return new ShapelessArcaneRecipe[0][];
        }
        ItemWandCasting wand = (ItemWandCasting)ConfigItems.itemWandCasting;
        WandCap baseCap = ConfigItems.WAND_CAP_GOLD;
        WandRod baseWandRod = ConfigItems.WAND_ROD_GREATWOOD;
        StaffRod baseStaffRod = ConfigItems.STAFF_ROD_GREATWOOD;
        ItemStack wandItem = new ItemStack((Item)wand);
        wand.setCap(wandItem, baseCap);
        wand.setRod(wandItem, baseWandRod);
        ItemStack staffItem = wandItem.copy();
        wand.setRod(staffItem, (WandRod)baseStaffRod);
        ItemStack scepterItem = wandItem.copy();
        scepterItem.setTagInfo("sceptre", (NBTBase)new NBTTagByte(1));
        ArrayList wandList = new ArrayList();
        ArrayList staffList = new ArrayList();
        ArrayList scepterList = new ArrayList();
        WandHelper.allVanillaCaps().stream().filter(wandCap -> wandCap != null && wandCap.getItem() != null && wandCap.getItem().getItem() != null).forEach(wandCap -> {
            if (baseCap == wandCap) {
                return;
            }
            ItemStack wandCapItem = wandCap.getItem();
            ItemStack outputWand = wandItem.copy();
            ItemStack outputStaff = staffItem.copy();
            ItemStack outputScepter = scepterItem.copy();
            wand.setCap(outputWand, wandCap);
            wand.setCap(outputStaff, wandCap);
            wand.setCap(outputScepter, wandCap);
            int wandCost = WandType.WAND.getCraftingVisCost((WandCap)wandCap, baseWandRod);
            wandList.add(new ShapelessArcaneRecipe(null, outputWand, AspectHelper.primalList(wandCost), new Object[]{wandItem, wandCapItem, wandCapItem}));
            int staffCost = WandType.STAFF.getCraftingVisCost((WandCap)wandCap, (WandRod)baseStaffRod);
            staffList.add(new ShapelessArcaneRecipe(null, outputStaff, AspectHelper.primalList(staffCost), new Object[]{staffItem.copy(), wandCapItem, wandCapItem}));
            int scepterCost = WandType.SCEPTER.getCraftingVisCost((WandCap)wandCap, baseWandRod);
            scepterList.add(new ShapelessArcaneRecipe(null, outputScepter, AspectHelper.primalList(scepterCost), new Object[]{scepterItem.copy(), wandCapItem, wandCapItem, wandCapItem}));
        });
        return new IArcaneRecipe[][]{wandList.toArray(new IArcaneRecipe[0]), staffList.toArray(new IArcaneRecipe[0]), scepterList.toArray(new IArcaneRecipe[0])};
    }

    private static IArcaneRecipe[][] exampleRodRecipes() {
        if (!SalisConfig.features.replaceWandCoreSettings.isEnabled()) {
            return new ShapelessArcaneRecipe[0][];
        }
        ItemWandCasting wand = (ItemWandCasting)ConfigItems.itemWandCasting;
        WandCap baseCap = ConfigItems.WAND_CAP_GOLD;
        WandRod baseWandRod = ConfigItems.WAND_ROD_GREATWOOD;
        StaffRod baseStaffRod = ConfigItems.STAFF_ROD_GREATWOOD;
        ItemStack wandItem = new ItemStack((Item)wand);
        wand.setCap(wandItem, baseCap);
        wand.setRod(wandItem, baseWandRod);
        ItemStack staffItem = wandItem.copy();
        wand.setRod(staffItem, (WandRod)baseStaffRod);
        ItemStack scepterItem = wandItem.copy();
        scepterItem.setTagInfo("sceptre", (NBTBase)new NBTTagByte(1));
        ArrayList wandList = new ArrayList();
        ArrayList scepterList = new ArrayList();
        ArrayList staffList = new ArrayList();
        ItemStack[] screw = new ItemStack[]{null};
        ItemStack[] conductor = new ItemStack[]{null};
        WandHelper.allVanillaRods().stream().filter(wandRod -> wandRod != null && wandRod.getItem() != null && wandRod.getItem().getItem() != null).forEach(wandRod -> {
            ItemStack rodItem = wandRod.getItem();
            if (wandRod instanceof StaffRod) {
                if (wandRod == baseStaffRod) {
                    return;
                }
                ItemStack outputStaff = staffItem.copy();
                wand.setRod(outputStaff, wandRod);
                int staffCost = WandType.STAFF.getCraftingVisCost(baseCap, (WandRod)wandRod);
                if (SalisConfig.modCompat.gtnhWands.coreSwapMaterials.isEnabled()) {
                    AbstractWandWrapper wrapper = GTNHTCWandsCompat.getWandWrapper(wandRod, WandType.getWandType(wandItem));
                    if (wrapper == null) {
                        wrapper = (AbstractWandWrapper)TCWandAPI.getWandWrappers().get(0);
                    }
                    WandDetails props = wrapper.getDetails();
                    screw[0] = (ItemStack)OreDictionary.getOres((String)props.getScrew()).get(0);
                    conductor[0] = props.getConductor();
                    staffList.add(new ShapelessArcaneRecipe(null, outputStaff, AspectHelper.primalList(staffCost), new Object[]{staffItem, rodItem, screw[0], screw[0], screw[0], screw[0], conductor[0], conductor[0]}));
                } else {
                    staffList.add(new ShapelessArcaneRecipe(null, outputStaff, AspectHelper.primalList(staffCost), new Object[]{staffItem, rodItem}));
                }
            } else {
                if (wandRod == baseWandRod) {
                    return;
                }
                ItemStack outputWand = wandItem.copy();
                ItemStack outputScepter = scepterItem.copy();
                wand.setRod(outputWand, wandRod);
                wand.setRod(outputScepter, wandRod);
                int wandCost = WandType.WAND.getCraftingVisCost(baseCap, (WandRod)wandRod);
                int scepterCost = WandType.SCEPTER.getCraftingVisCost(baseCap, (WandRod)wandRod);
                if (SalisConfig.modCompat.gtnhWands.coreSwapMaterials.isEnabled()) {
                    AbstractWandWrapper wrapper = GTNHTCWandsCompat.getWandWrapper(wandRod, WandType.getWandType(wandItem));
                    if (wrapper == null) {
                        wrapper = (AbstractWandWrapper)TCWandAPI.getWandWrappers().get(0);
                    }
                    WandDetails props = wrapper.getDetails();
                    screw[0] = (ItemStack)OreDictionary.getOres((String)props.getScrew()).get(0);
                    conductor[0] = props.getConductor();
                    wandList.add(new ShapelessArcaneRecipe(null, outputWand, AspectHelper.primalList(wandCost), new Object[]{wandItem, rodItem, screw[0], screw[0], screw[0], screw[0], conductor[0], conductor[0]}));
                    scepterList.add(new ShapelessArcaneRecipe(null, outputScepter, AspectHelper.primalList(scepterCost), new Object[]{scepterItem, rodItem, screw[0], screw[0], conductor[0], conductor[0]}));
                } else {
                    wandList.add(new ShapelessArcaneRecipe(null, outputWand, AspectHelper.primalList(wandCost), new Object[]{wandItem, rodItem}));
                    scepterList.add(new ShapelessArcaneRecipe(null, outputScepter, AspectHelper.primalList(scepterCost), new Object[]{scepterItem, rodItem}));
                }
            }
        });
        return new IArcaneRecipe[][]{wandList.toArray(new IArcaneRecipe[0]), scepterList.toArray(new IArcaneRecipe[0]), staffList.toArray(new IArcaneRecipe[0])};
    }

    private static ResearchItem maybeRegister(CustomResearchSetting settings, Item placeholderItem, IArcaneRecipe[] ... recipeSets) {
        if (!settings.isEnabled()) {
            return null;
        }
        String fullKey = settings.getInternalName();
        String category = settings.researchCategory;
        int col = settings.researchCol;
        int row = settings.researchRow;
        ResearchItem research = new ResearchItem(fullKey, category, settings.getAspects(), col, row, settings.difficulty, new ItemStack(placeholderItem, 0, Short.MAX_VALUE)).setConcealed().setParents(settings.parentResearches).setSpecial();
        if (settings.autoUnlock) {
            research.setStub();
            for (String parentResearch : settings.parentResearches) {
                ResearchItem sibling = ResearchCategories.getResearch((String)parentResearch);
                if (sibling == null) {
                    SalisArcana.LOG.error("Could not locate research {} for {}.", new Object[]{parentResearch, fullKey});
                    continue;
                }
                sibling.siblings = ArrayHelper.appendToArray(sibling.siblings, fullKey);
            }
        } else if (research.tags.size() == 0) {
            SalisArcana.LOG.error("Research {} does not have any aspects set but is not auto-unlockable, making it impossible to research.", new Object[]{fullKey});
        }
        if (settings.warp > 0) {
            ThaumcraftApi.addWarpToResearch((String)fullKey, (int)settings.warp);
        }
        ArrayList<ResearchPage> pages = new ArrayList<ResearchPage>();
        pages.add(new ResearchPage("tc.research_page." + fullKey + ".0"));
        for (IArcaneRecipe[] recipeSet : recipeSets) {
            if (recipeSet.length < 1) continue;
            pages.add(new ResearchPage(recipeSet));
        }
        research.setPages(pages.toArray(new ResearchPage[0]));
        if (settings.purchasable) {
            research.setSecondary();
        }
        research.registerResearchItem();
        return research;
    }
}

