/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common;

import dev.rndmorris.salisarcana.config.SalisConfig;
import dev.rndmorris.salisarcana.config.settings.CustomResearchSetting;
import dev.rndmorris.salisarcana.lib.ArrayHelper;
import dev.rndmorris.salisarcana.lib.FormattedResearchPage;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;
import thaumcraft.api.wands.FocusUpgradeType;

public class DisenchantFocusUpgrade
extends FocusUpgradeType {
    public static final String RESEARCH_KEY = "salisarcana:FOCUS_DISENCHANTING";
    private static final int[] RANK_TO_XP_POINTS = new int[]{136, 272, 516, 956, 1760};
    private static final ResourceLocation ICON_LOCATION = new ResourceLocation("salisarcana", "textures/foci/disenchant.png");
    private static final String NAME_KEY = "focus.upgrade.salisarcana:disenchant.name";
    private static final String UNFORMATTED_TOOLTIP_KEY = "focus.upgrade.salisarcana:disenchant.text";
    private static final String GENERIC_TOOLTIP_KEY = "focus.upgrade.salisarcana:disenchant.text.generic";
    private static final String SPECIFIC_TOOLTIP_KEY = "focus.upgrade.salisarcana:disenchant.text.specific";
    private static final AspectList ASPECT_VALUE = new AspectList().add(Aspect.ENTROPY, 1);
    public static short upgradeID;
    public static DisenchantFocusUpgrade baseInstance;
    public static ResearchItem researchItem;
    public final FocusUpgradeType lastUpgrade;
    public final int lastUpgradeLevel;
    public final int lastRank;

    public static void initialize() {
        upgradeID = (short)FocusUpgradeType.types.length;
        baseInstance = new DisenchantFocusUpgrade(upgradeID);
    }

    public static void registerResearch() {
        int percentXP = SalisConfig.features.focusDisenchantingRefundPercentage.getValue();
        CustomResearchSetting data = SalisConfig.features.focusDisenchantingResearch;
        researchItem = new ResearchItem(RESEARCH_KEY, data.researchCategory, data.getAspects(), data.researchCol, data.researchRow, data.difficulty, ICON_LOCATION);
        researchItem.setPages(new ResearchPage[]{new FormattedResearchPage("tc.research_page.salisarcana:FOCUS_DISENCHANTING.0", new Object[]{percentXP}), new ResearchPage("tc.research_page.salisarcana:FOCUS_DISENCHANTING.1")});
        researchItem.setConcealed().setSecondary().setParents(data.parentResearches).registerResearchItem();
        if (data.warp > 0) {
            ThaumcraftApi.addWarpToResearch((String)RESEARCH_KEY, (int)data.warp);
        }
        if (data.autoUnlock) {
            researchItem.setStub();
            for (String parentID : data.parentResearches) {
                ResearchItem parent = ResearchCategories.getResearch((String)parentID);
                parent.siblings = ArrayHelper.appendToArray(parent.siblings, RESEARCH_KEY);
            }
        }
    }

    public static DisenchantFocusUpgrade createSpecific(short[] upgrades) {
        FocusUpgradeType.types[DisenchantFocusUpgrade.upgradeID] = null;
        DisenchantFocusUpgrade out = new DisenchantFocusUpgrade(upgradeID, upgrades);
        FocusUpgradeType.types[DisenchantFocusUpgrade.upgradeID] = baseInstance;
        return out;
    }

    private DisenchantFocusUpgrade(short id) {
        super((int)id, ICON_LOCATION, NAME_KEY, UNFORMATTED_TOOLTIP_KEY, ASPECT_VALUE);
        this.lastUpgrade = null;
        this.lastUpgradeLevel = -1;
        this.lastRank = -1;
    }

    private DisenchantFocusUpgrade(short id, short[] upgrades) {
        super((int)id, ICON_LOCATION, NAME_KEY, UNFORMATTED_TOOLTIP_KEY, ASPECT_VALUE);
        if (upgrades.length == 0 || upgrades[0] == -1) {
            this.lastUpgrade = null;
            this.lastUpgradeLevel = -1;
            this.lastRank = -1;
        } else {
            int rank;
            for (rank = 1; rank < upgrades.length && upgrades[rank] != -1; ++rank) {
            }
            this.lastRank = rank;
            short lastUpgradeID = upgrades[rank - 1];
            this.lastUpgrade = FocusUpgradeType.types[lastUpgradeID];
            int level = 1;
            for (int i = rank - 2; i >= 0; --i) {
                if (upgrades[i] != lastUpgradeID) continue;
                ++level;
            }
            this.lastUpgradeLevel = level;
        }
    }

    public String getLocalizedText() {
        if (this.lastUpgradeLevel > 0) {
            StringBuilder upgradeName = new StringBuilder(this.lastUpgrade.getLocalizedName());
            if (this.lastUpgradeLevel > 1) {
                upgradeName.append(' ');
                upgradeName.append(StatCollector.translateToLocal((String)("enchantment.level." + this.lastUpgradeLevel)));
            }
            return StatCollector.translateToLocalFormatted((String)SPECIFIC_TOOLTIP_KEY, (Object[])new Object[]{upgradeName.toString(), this.getXpPoints()});
        }
        return StatCollector.translateToLocalFormatted((String)GENERIC_TOOLTIP_KEY, (Object[])new Object[]{SalisConfig.features.focusDisenchantingRefundPercentage.getValue()});
    }

    public int getXpPoints() {
        return RANK_TO_XP_POINTS[Math.min(this.lastRank, 5) - 1] * SalisConfig.features.focusDisenchantingRefundPercentage.getValue() / 100;
    }

    public AspectList getVisPoints() {
        return new AspectList().add(Aspect.ENTROPY, 100 << this.lastRank);
    }
}

