/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands;

import dev.rndmorris.salisarcana.SalisArcana;
import dev.rndmorris.salisarcana.common.commands.arguments.ArgumentProcessor;
import dev.rndmorris.salisarcana.config.settings.CommandSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public abstract class ArcanaCommandBase<T>
extends CommandBase {
    protected final CommandSettings settings;
    protected final ArgumentProcessor<T> argumentProcessor;

    public ArcanaCommandBase(@Nonnull CommandSettings settings) {
        settings.setCommandGetter(() -> this);
        this.settings = settings;
        this.argumentProcessor = this.initializeProcessor();
    }

    @Nonnull
    protected abstract ArgumentProcessor<T> initializeProcessor();

    public String getCommandName() {
        return this.settings.getFullName();
    }

    public List<String> getCommandAliases() {
        return new ArrayList<String>(this.settings.aliases);
    }

    public String getCommandUsage(ICommandSender sender) {
        return String.format("%s:command.%s.usage", "salisarcana", this.settings.name);
    }

    public int getRequiredPermissionLevel() {
        return this.settings.getPermissionLevel();
    }

    public boolean canCommandSenderUseCommand(ICommandSender sender) {
        return this.getRequiredPermissionLevel() == 0 || super.canCommandSenderUseCommand(sender);
    }

    public void processCommand(ICommandSender sender, String[] args) {
        if (args.length < this.minimumRequiredArgs()) {
            this.printUsage(sender);
            return;
        }
        try {
            this.process(sender, this.argumentProcessor.process(sender, args), args);
        }
        catch (Exception ex) {
            if (ex instanceof CommandException) {
                CommandException ce = (CommandException)ex;
                throw ce;
            }
            SalisArcana.LOG.error(String.format("An error occurred for player %s while executing /%s.", sender.getCommandSenderName(), String.join((CharSequence)" ", args)), (Throwable)ex);
            sender.addChatMessage(new ChatComponentTranslation("salisarcana:command.error.execute", new Object[0]).setChatStyle(new ChatStyle().setColor(EnumChatFormatting.RED)));
        }
    }

    public List<String> addTabCompletionOptions(ICommandSender sender, String[] args) {
        try {
            return CommandBase.getListOfStringsFromIterableMatchingLastWord((String[])args, this.argumentProcessor.getAutocompletionSuggestions(sender, args));
        }
        catch (Exception ex) {
            SalisArcana.LOG.error(String.format("An error occurred for player %s while providing tab completion for /%s.", sender.getCommandSenderName(), String.join((CharSequence)" ", args)), (Throwable)ex);
            sender.addChatMessage(new ChatComponentTranslation("salisarcana:command.error.tabcomplete", new Object[0]).setChatStyle(new ChatStyle().setColor(EnumChatFormatting.RED)));
            return null;
        }
    }

    protected ChatStyle titleStyle() {
        ChatStyle titleStyle = new ChatStyle();
        titleStyle.setBold(Boolean.valueOf(true));
        titleStyle.setColor(EnumChatFormatting.BLUE);
        return titleStyle;
    }

    public void printHelp(ICommandSender sender) {
        ChatStyle titleStyle = this.titleStyle();
        ChatComponentTranslation description = new ChatComponentTranslation("salisarcana:command.desc", new Object[0]);
        description.setChatStyle(titleStyle);
        description.appendText(" ");
        ChatComponentTranslation descriptionText = new ChatComponentTranslation(String.format("salisarcana:command.%s.desc", this.settings.name), new Object[0]);
        descriptionText.getChatStyle().setColor(EnumChatFormatting.RESET).setBold(Boolean.valueOf(false));
        description.appendSibling((IChatComponent)descriptionText);
        ChatComponentTranslation usageTitle = new ChatComponentTranslation("salisarcana:command.usage", new Object[0]);
        usageTitle.setChatStyle(titleStyle);
        ChatComponentTranslation argumentsTitle = new ChatComponentTranslation("salisarcana:command.args", new Object[0]);
        argumentsTitle.setChatStyle(titleStyle);
        Stream<ChatComponentTranslation> first = Arrays.stream(new ChatComponentTranslation[]{description, usageTitle, new ChatComponentTranslation(String.format("salisarcana:command.%s.usage", this.settings.name), new Object[0]), argumentsTitle});
        Stream<ChatComponentTranslation> descLangKeys = this.argumentProcessor.descriptionLangKeys.stream().map(key -> new ChatComponentTranslation(String.format("salisarcana:command.%s.args.%s", this.settings.name, key), new Object[0]));
        Stream.concat(first, descLangKeys).forEachOrdered(arg_0 -> ((ICommandSender)sender).addChatMessage(arg_0));
    }

    public void printUsage(ICommandSender sender) {
        sender.addChatMessage(new ChatComponentTranslation("salisarcana:command.usage", new Object[0]).setChatStyle(this.titleStyle()));
        sender.addChatMessage((IChatComponent)new ChatComponentTranslation(this.getCommandUsage(sender), new Object[0]));
    }

    protected abstract int minimumRequiredArgs();

    protected abstract void process(ICommandSender var1, T var2, String[] var3);
}

