/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import dev.rndmorris.salisarcana.common.commands.ArcanaCommandBase;
import dev.rndmorris.salisarcana.common.commands.CommandErrors;
import dev.rndmorris.salisarcana.common.commands.arguments.ArgumentProcessor;
import dev.rndmorris.salisarcana.common.commands.arguments.annotations.FlagArg;
import dev.rndmorris.salisarcana.common.commands.arguments.annotations.NamedArg;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.IArgumentHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.ResearchKeyHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.flag.FlagHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.named.PlayerHandler;
import dev.rndmorris.salisarcana.config.SalisConfig;
import dev.rndmorris.salisarcana.network.MessageForgetResearch;
import dev.rndmorris.salisarcana.network.NetworkHandler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.playerdata.PacketSyncWarp;
import thaumcraft.common.lib.research.PlayerKnowledge;

public class ForgetResearchCommand
extends ArcanaCommandBase<Arguments> {
    public ForgetResearchCommand() {
        super(SalisConfig.commands.forgetResearch);
    }

    @Override
    @Nonnull
    protected ArgumentProcessor<Arguments> initializeProcessor() {
        return new ArgumentProcessor<Arguments>(Arguments.class, Arguments::new, new IArgumentHandler[]{PlayerHandler.INSTANCE, ResearchKeyHandler.INSTANCE, FlagHandler.INSTANCE});
    }

    @Override
    protected void process(ICommandSender sender, Arguments arguments, String[] args) {
        ArrayList playerResearch;
        if (arguments.targetPlayer == null) {
            arguments.targetPlayer = ForgetResearchCommand.getCommandSenderAsPlayer((ICommandSender)sender);
        }
        if (arguments.researchKeys.isEmpty() && !arguments.allResearch) {
            CommandErrors.invalidSyntax();
        }
        if ((playerResearch = (ArrayList)Thaumcraft.proxy.getPlayerKnowledge().researchCompleted.get(arguments.targetPlayer.getCommandSenderName())) == null) {
            return;
        }
        ArrayDeque<String> toForget = new ArrayDeque<String>();
        if (arguments.allResearch) {
            toForget.addAll(playerResearch);
        } else {
            toForget.addAll(arguments.researchKeys);
        }
        Map<String, ResearchItem> researchMap = playerResearch.stream().filter(Objects::nonNull).map(ResearchCategories::getResearch).filter(Objects::nonNull).collect(Collectors.toMap(r -> r.key, r -> r));
        TreeSet visited = new TreeSet(toForget);
        int permWarp = 0;
        int stickyWarp = 0;
        int removedCount = 0;
        ArrayList<String> removed = new ArrayList<String>();
        while (!toForget.isEmpty()) {
            String key = (String)toForget.poll();
            ResearchItem data = researchMap.get(key);
            if (data == null) continue;
            if (!data.isAutoUnlock()) {
                int warp;
                ++removedCount;
                int removeIndex = playerResearch.indexOf(key);
                if (removeIndex >= 0) {
                    playerResearch.remove(removeIndex);
                    removed.add(key);
                }
                if ((warp = ThaumcraftApi.getWarp((Object)key)) > 0 && !Config.wuss && !arguments.targetPlayer.worldObj.isRemote) {
                    int sticky = warp / 2;
                    permWarp += warp - sticky;
                    stickyWarp += sticky;
                }
            }
            if (arguments.scalpel) continue;
            Predicate<ResearchItem> isChildResearch = r -> {
                if (r.parents != null) {
                    for (String parent : r.parents) {
                        if (!key.equals(parent)) continue;
                        return true;
                    }
                }
                if (r.parentsHidden != null) {
                    for (String parent : r.parentsHidden) {
                        if (!key.equals(parent)) continue;
                        return true;
                    }
                }
                if (r.siblings != null) {
                    for (String sibling : r.siblings) {
                        if (!key.equals(sibling)) continue;
                        return true;
                    }
                }
                return false;
            };
            researchMap.values().stream().filter(r -> !visited.contains(r.key) && isChildResearch.test((ResearchItem)r)).forEach(r -> {
                toForget.add(r.key);
                visited.add(r.key);
            });
        }
        EntityPlayerMP target = arguments.targetPlayer;
        if (!arguments.retainWarp) {
            PlayerKnowledge knowledge = Thaumcraft.proxy.getPlayerKnowledge();
            if (permWarp > 0) {
                knowledge.addWarpPerm(target.getCommandSenderName(), -permWarp);
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncWarp((EntityPlayer)target, 0), target);
            }
            if (stickyWarp > 0) {
                knowledge.addWarpSticky(target.getCommandSenderName(), -stickyWarp);
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncWarp((EntityPlayer)target, 1), target);
            }
            if (permWarp > 0 || stickyWarp > 0) {
                knowledge.setWarpCounter(target.getCommandSenderName(), knowledge.getWarpTotal(target.getCommandSenderName()));
            }
        }
        NetworkHandler.instance.sendTo((IMessage)new MessageForgetResearch(removed), arguments.targetPlayer);
        sender.addChatMessage((IChatComponent)new ChatComponentTranslation(arguments.retainWarp ? "salisarcana:command.forget-research.retain" : "salisarcana:command.forget-research.remove", new Object[]{removedCount, permWarp, stickyWarp}));
    }

    @Override
    protected int minimumRequiredArgs() {
        return 1;
    }

    public static class Arguments {
        @FlagArg(name="--all", excludes={"--research-key", "--scalpel"}, descLangKey="all")
        public boolean allResearch;
        @NamedArg(name="--research-key", handler=ResearchKeyHandler.class, excludes={"--all"}, descLangKey="research")
        public ArrayList<String> researchKeys = new ArrayList();
        @NamedArg(name="--player", handler=PlayerHandler.class, descLangKey="player")
        public EntityPlayerMP targetPlayer;
        @FlagArg(name="--scalpel", excludes={"--all"}, descLangKey="scalpel")
        public boolean scalpel;
        @FlagArg(name="--retain-warp", descLangKey="retain-warp")
        public boolean retainWarp;
    }
}

