/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import dev.rndmorris.salisarcana.common.commands.ArcanaCommandBase;
import dev.rndmorris.salisarcana.common.commands.arguments.ArgumentProcessor;
import dev.rndmorris.salisarcana.common.commands.arguments.annotations.FlagArg;
import dev.rndmorris.salisarcana.common.commands.arguments.annotations.NamedArg;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.IArgumentHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.flag.FlagHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.named.AspectHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.named.PlayerHandler;
import dev.rndmorris.salisarcana.config.SalisConfig;
import dev.rndmorris.salisarcana.lib.InventoryHelper;
import dev.rndmorris.salisarcana.network.MessageForgetScannedCategory;
import dev.rndmorris.salisarcana.network.MessageForgetScannedObjects;
import dev.rndmorris.salisarcana.network.NetworkHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.research.PlayerKnowledge;
import thaumcraft.common.lib.research.ScanManager;
import thaumcraft.common.lib.utils.BlockUtils;

public class ForgetScannedCommand
extends ArcanaCommandBase<Arguments> {
    public ForgetScannedCommand() {
        super(SalisConfig.commands.forgetScanned);
    }

    @Override
    @Nonnull
    protected ArgumentProcessor<Arguments> initializeProcessor() {
        return new ArgumentProcessor<Arguments>(Arguments.class, Arguments::new, new IArgumentHandler[]{PlayerHandler.INSTANCE, FlagHandler.INSTANCE, AspectHandler.INSTANCE});
    }

    @Override
    protected void process(ICommandSender sender, Arguments arguments, String[] args) {
        boolean forgetNodes;
        boolean forgetEntities;
        boolean forgetObjects;
        EntityPlayerMP targetPlayer = arguments.targetPlayer != null ? arguments.targetPlayer : ForgetScannedCommand.getCommandSenderAsPlayer((ICommandSender)sender);
        String playerName = targetPlayer.getCommandSenderName();
        PlayerKnowledge playerKnowledge = Thaumcraft.proxy.getPlayerKnowledge();
        HashSet<Integer> forgottenHashes = new HashSet<Integer>();
        if (arguments.hand) {
            forgottenHashes.addAll(this.forgetItems(targetPlayer, Collections.singletonList(targetPlayer.getHeldItem())));
        }
        if (arguments.inventory) {
            forgottenHashes.addAll(this.forgetItems(targetPlayer, InventoryHelper.getItemStacks((IInventory)targetPlayer.inventory)));
        }
        if (arguments.looking || arguments.container) {
            TileEntity tile;
            Block block;
            MovingObjectPosition target = this.getLookingAt((EntityPlayer)targetPlayer);
            if (arguments.looking && (block = targetPlayer.worldObj.getBlock(target.blockX, target.blockY, target.blockZ)) != null) {
                ItemStack item = new ItemStack(block, 1, targetPlayer.worldObj.getBlockMetadata(target.blockX, target.blockY, target.blockZ));
                forgottenHashes.addAll(this.forgetItems(targetPlayer, Collections.singletonList(item)));
            }
            if (arguments.container && (tile = targetPlayer.worldObj.getTileEntity(target.blockX, target.blockY, target.blockZ)) instanceof IInventory) {
                IInventory inventory = (IInventory)tile;
                forgottenHashes.addAll(this.forgetItems(targetPlayer, InventoryHelper.getItemStacks(inventory)));
            }
        }
        if (!forgottenHashes.isEmpty()) {
            NetworkHandler.instance.sendTo((IMessage)new MessageForgetScannedObjects(forgottenHashes), targetPlayer);
        }
        ArrayList<Map<String, ArrayList<String>>> removeFromMaps = new ArrayList<Map<String, ArrayList<String>>>(3);
        boolean bl = forgetObjects = arguments.all || arguments.objects;
        if (forgetObjects) {
            removeFromMaps.add(playerKnowledge.objectsScanned);
        }
        boolean bl2 = forgetEntities = arguments.all || arguments.entities;
        if (forgetEntities) {
            removeFromMaps.add(playerKnowledge.entitiesScanned);
        }
        boolean bl3 = forgetNodes = arguments.all || arguments.nodes;
        if (forgetNodes) {
            removeFromMaps.add(playerKnowledge.phenomenaScanned);
        }
        int removedCount = forgottenHashes.size();
        if (!removeFromMaps.isEmpty()) {
            removedCount += this.forgetCategories(playerName, removeFromMaps);
            NetworkHandler.instance.sendTo((IMessage)new MessageForgetScannedCategory(forgetObjects, forgetEntities, forgetNodes), targetPlayer);
        }
        if (removedCount > 0) {
            sender.addChatMessage((IChatComponent)new ChatComponentTranslation("salisarcana:command.forget-scanned.success", new Object[]{removedCount, playerName}));
        } else {
            sender.addChatMessage((IChatComponent)new ChatComponentTranslation("salisarcana:command.forget-scanned.failure", new Object[]{playerName}));
        }
    }

    private int forgetCategories(String playerName, List<Map<String, ArrayList<String>>> toClear) {
        int count = 0;
        for (Map<String, ArrayList<String>> map : toClear) {
            ArrayList<String> list;
            if (map == null || (list = map.get(playerName)) == null) continue;
            count += list.size();
            list.clear();
        }
        return count;
    }

    private Set<Integer> forgetItems(EntityPlayerMP targetPlayer, Collection<ItemStack> items) {
        if (items.isEmpty()) {
            return Collections.emptySet();
        }
        PlayerKnowledge playerKnowledge = Thaumcraft.proxy.getPlayerKnowledge();
        String playerName = targetPlayer.getCommandSenderName();
        ArrayList objectsScanned = (ArrayList)playerKnowledge.objectsScanned.get(playerName);
        if (objectsScanned == null || objectsScanned.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Integer> forgottenHashes = new HashSet<Integer>(items.size());
        for (ItemStack item : items) {
            if (item == null || item.getItem() == null) continue;
            int hash = ScanManager.generateItemHash((Item)item.getItem(), (int)item.getItemDamage());
            String key = "@" + hash;
            if (!objectsScanned.remove(key)) continue;
            forgottenHashes.add(hash);
        }
        return forgottenHashes;
    }

    private MovingObjectPosition getLookingAt(EntityPlayer player) {
        return BlockUtils.getTargetBlock((World)player.worldObj, (Entity)player, (boolean)false);
    }

    @Override
    protected int minimumRequiredArgs() {
        return 1;
    }

    public static class Arguments {
        @NamedArg(name="--player", handler=PlayerHandler.class, descLangKey="player")
        public EntityPlayerMP targetPlayer;
        @FlagArg(name="--objects", excludes={"--all"}, descLangKey="objects")
        public boolean objects;
        @FlagArg(name="--entities", excludes={"--all"}, descLangKey="entities")
        public boolean entities;
        @FlagArg(name="--nodes", excludes={"--all"}, descLangKey="nodes")
        public boolean nodes;
        @FlagArg(name="--all", excludes={"--objects", "--entities", "--nodes"}, descLangKey="all")
        public boolean all;
        @FlagArg(name="--hand", excludes={"--all"}, descLangKey="hand")
        public boolean hand;
        @FlagArg(name="--inventory", excludes={"--all"}, descLangKey="research")
        public boolean inventory;
        @FlagArg(name="--looking", excludes={"--all"}, descLangKey="looking")
        public boolean looking;
        @FlagArg(name="--container", excludes={"--all"}, descLangKey="container")
        public boolean container;
    }
}

