/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands;

import dev.rndmorris.salisarcana.common.commands.ArcanaCommandBase;
import dev.rndmorris.salisarcana.common.commands.arguments.ArgumentProcessor;
import dev.rndmorris.salisarcana.common.commands.arguments.annotations.NamedArg;
import dev.rndmorris.salisarcana.common.commands.arguments.annotations.PositionalArg;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.FocusUpgradesHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.IArgumentHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.named.PlayerHandler;
import dev.rndmorris.salisarcana.config.SalisConfig;
import dev.rndmorris.salisarcana.lib.WandFocusHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;

public class UpgradeFocusCommand
extends ArcanaCommandBase<Arguments> {
    public UpgradeFocusCommand() {
        super(SalisConfig.commands.upgradeFocus);
    }

    @Override
    @Nonnull
    protected ArgumentProcessor<Arguments> initializeProcessor() {
        return new ArgumentProcessor<Arguments>(Arguments.class, Arguments::new, new IArgumentHandler[]{FocusUpgradesHandler.INSTANCE, PlayerHandler.INSTANCE});
    }

    @Override
    protected int minimumRequiredArgs() {
        return 0;
    }

    @Override
    protected void process(ICommandSender sender, Arguments arguments, String[] args) {
        EntityPlayerMP executingPlayer = CommandBase.getCommandSenderAsPlayer((ICommandSender)sender);
        if (arguments.player == null) {
            arguments.player = executingPlayer;
        }
        if (arguments.upgrades == null || arguments.upgrades.size() < 1) {
            throw new CommandException("salisarcana:command.upgrade-focus.noUpgrades", new Object[0]);
        }
        ItemStack heldItem = arguments.player.getCurrentEquippedItem();
        ItemFocusBasic heldFocus = WandFocusHelper.getFocusFrom(heldItem);
        if (heldItem == null || heldFocus == null) {
            throw new CommandException("salisarcana:command.upgrade-focus.noItem", new Object[0]);
        }
        List<FocusUpgradeType> appliedUpgrades = WandFocusHelper.getAppliedUpgrades(heldFocus, heldItem);
        int applied = 0;
        for (FocusUpgradeType upgrade : arguments.upgrades) {
            if (appliedUpgrades.size() == 5) {
                throw new CommandException("salisarcana:command.upgrade-focus.tooManyUpgrades", new Object[]{arguments.upgrades.size() - applied});
            }
            appliedUpgrades.add(upgrade);
            heldFocus.applyUpgrade(heldItem, upgrade, appliedUpgrades.size());
            ++applied;
        }
        sender.addChatMessage((IChatComponent)new ChatComponentTranslation("salisarcana:command.upgrade-focus.success", new Object[0]));
    }

    public static class Arguments {
        @PositionalArg(index=0, handler=FocusUpgradesHandler.class, descLangKey="upgrades")
        public ArrayList<FocusUpgradeType> upgrades;
        @NamedArg(name="--player", handler=PlayerHandler.class, descLangKey="player")
        public EntityPlayerMP player;
    }
}

