/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands.arguments.handlers;

import com.google.common.collect.PeekingIterator;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.IntHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.named.INamedArgumentHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.positional.IPositionalArgumentHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemHandler
implements INamedArgumentHandler,
IPositionalArgumentHandler {
    public static final ItemHandler INSTANCE = new ItemHandler();
    private final List<String> itemKeys;
    private final IntHandler metadataHandler = new IntHandler(0, Integer.MAX_VALUE, 0);

    public ItemHandler() {
        this(null);
    }

    public ItemHandler(Collection<String> itemKeys) {
        this.itemKeys = itemKeys != null ? new ArrayList<String>(itemKeys) : null;
    }

    @Override
    public Object parse(ICommandSender sender, PeekingIterator<String> args) {
        Item item = CommandBase.getItemByText((ICommandSender)sender, (String)((String)args.next()));
        Integer damage = null;
        if (args.hasNext()) {
            damage = (Integer)this.metadataHandler.parse(sender, args);
        }
        if (damage == null) {
            damage = this.metadataHandler.getSuggestedValue();
        }
        return new ItemStack(item, 0, damage.intValue());
    }

    @Override
    public List<String> getAutocompleteOptions(ICommandSender sender, PeekingIterator<String> args) {
        args.next();
        if (!args.hasNext()) {
            if (this.itemKeys != null) {
                return this.itemKeys;
            }
            return new ArrayList<String>(Item.itemRegistry.getKeys());
        }
        return this.metadataHandler.getAutocompleteOptions(sender, args);
    }

    @Override
    @Nonnull
    public Class<?> getOutputType() {
        return ItemStack.class;
    }
}

