/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands.arguments.handlers.named;

import com.google.common.collect.PeekingIterator;
import dev.rndmorris.salisarcana.common.commands.arguments.QuantitativeAspectArgument;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.IArgumentHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.named.INamedArgumentHandler;
import dev.rndmorris.salisarcana.lib.AspectHelper;
import dev.rndmorris.salisarcana.lib.IntegerHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import thaumcraft.api.aspects.Aspect;

public class QuantitativeAspectHandler
implements INamedArgumentHandler {
    public static final IArgumentHandler INSTANCE = new QuantitativeAspectHandler();

    @Override
    public Object parse(ICommandSender sender, PeekingIterator<String> args) {
        String peeked;
        TreeSet<QuantitativeAspectArgument> result = new TreeSet<QuantitativeAspectArgument>(QuantitativeAspectArgument.COMPARATOR);
        do {
            String tag = args.hasNext() ? (String)args.next() : "";
            Aspect aspect = AspectHelper.aspectsCI().get(tag);
            if (aspect == null) {
                throw new CommandException("salisarcana:error.invalid_aspect", new Object[]{tag});
            }
            String amountStr = args.hasNext() ? (String)args.next() : "";
            int amount = CommandBase.parseIntWithMin((ICommandSender)sender, (String)amountStr, (int)1);
            result.add(new QuantitativeAspectArgument(aspect, amount));
        } while (args.hasNext() && (peeked = (String)args.peek()) != null && !peeked.startsWith("-"));
        return new ArrayList<QuantitativeAspectArgument>(result);
    }

    @Override
    public List<String> getAutocompleteOptions(ICommandSender sender, PeekingIterator<String> args) {
        String peeked;
        TreeSet<QuantitativeAspectArgument> alreadyFound = new TreeSet<QuantitativeAspectArgument>(QuantitativeAspectArgument.COMPARATOR);
        do {
            if (!args.hasNext()) {
                return this.aspectSuggestions(alreadyFound);
            }
            String tag = (String)args.next();
            Aspect aspect = AspectHelper.aspectsCI().get(tag);
            if (aspect == null) {
                return this.aspectSuggestions(alreadyFound);
            }
            if (!args.hasNext()) {
                return Collections.singletonList("1");
            }
            String amountStr = (String)args.next();
            Integer amount = IntegerHelper.tryParseWithMin(amountStr, 1);
            if (amount == null) {
                return Collections.singletonList("1");
            }
            alreadyFound.add(new QuantitativeAspectArgument(aspect, amount));
        } while (args.hasNext() && (peeked = (String)args.peek()) != null && !peeked.startsWith("-"));
        return null;
    }

    private List<String> aspectSuggestions(Set<QuantitativeAspectArgument> except) {
        return new ArrayList<Aspect>(AspectHelper.aspectsExcept(except.stream().map(a -> a.aspect).collect(Collectors.toList()))).stream().map(Aspect::getTag).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public Class<?> getOutputType() {
        return List.class;
    }
}

