/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands.arguments.handlers.positional;

import com.google.common.collect.PeekingIterator;
import dev.rndmorris.salisarcana.common.commands.CommandErrors;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.IArgumentHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.positional.IPositionalArgumentHandler;
import dev.rndmorris.salisarcana.config.SalisConfig;
import dev.rndmorris.salisarcana.config.settings.CommandSettings;
import dev.rndmorris.salisarcana.config.settings.Setting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;

public class CommandNameHandler
implements IPositionalArgumentHandler {
    public static final IArgumentHandler INSTANCE = new CommandNameHandler();

    @Override
    public Object parse(ICommandSender sender, PeekingIterator<String> args) {
        CommandSettings command = this.findCommand((String)args.next());
        if (command == null) {
            CommandErrors.commandNotFound();
        }
        if (!sender.canCommandSenderUseCommand(command.getPermissionLevel(), command.getFullName())) {
            CommandErrors.insufficientPermission();
        }
        return command;
    }

    @Override
    public List<String> getAutocompleteOptions(ICommandSender sender, PeekingIterator<String> args) {
        args.next();
        List settingsList = SalisConfig.commands.getCommandsSettings().collect(Collectors.toList());
        if (!args.hasNext()) {
            TreeSet<String> results = new TreeSet<String>(String::compareToIgnoreCase);
            for (CommandSettings settings : settingsList) {
                if (!settings.isEnabled()) continue;
                Collections.addAll(results, settings.getFullName());
                results.addAll(settings.aliases);
            }
            return new ArrayList<String>(results);
        }
        return null;
    }

    @Override
    @Nonnull
    public Class<?> getOutputType() {
        return CommandSettings.class;
    }

    private CommandSettings findCommand(String current) {
        List maybeFoundCommand = SalisConfig.commands.getCommandsSettings().filter(Setting::isEnabled).filter(s -> s.getFullName().equalsIgnoreCase(current) || s.aliases.stream().anyMatch(a -> a.equalsIgnoreCase(current))).limit(1L).collect(Collectors.toList());
        return !maybeFoundCommand.isEmpty() ? (CommandSettings)maybeFoundCommand.get(0) : null;
    }
}

