/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands.arguments.handlers.positional;

import com.google.common.collect.PeekingIterator;
import dev.rndmorris.salisarcana.common.commands.CommandErrors;
import dev.rndmorris.salisarcana.common.commands.arguments.CoordinateArgument;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.IArgumentHandler;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.positional.IPositionalArgumentHandler;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;

public class CoordinateHandler
implements IPositionalArgumentHandler {
    public static final IArgumentHandler INSTANCE = new CoordinateHandler();

    @Override
    public Object parse(ICommandSender sender, PeekingIterator<String> args) {
        EntityPlayerMP player = CommandBase.getCommandSenderAsPlayer((ICommandSender)sender);
        int x = this.parsePosition(sender, player.posX, (String)args.next());
        if (!args.hasNext()) {
            CommandErrors.invalidSyntax();
        }
        int y = this.parsePosition(sender, player.posY, (String)args.next());
        if (!args.hasNext()) {
            CommandErrors.invalidSyntax();
        }
        int z = this.parsePosition(sender, player.posZ, (String)args.next());
        return new CoordinateArgument(x, y, z);
    }

    private int parsePosition(ICommandSender sender, double playerPosition, String value) {
        return MathHelper.floor_double((double)CommandBase.func_110666_a((ICommandSender)sender, (double)playerPosition, (String)value));
    }

    @Override
    public List<String> getAutocompleteOptions(ICommandSender sender, PeekingIterator<String> args) {
        List<String> tilde = Collections.singletonList("~");
        args.next();
        if (!args.hasNext()) {
            return tilde;
        }
        args.next();
        if (!args.hasNext()) {
            return tilde;
        }
        args.next();
        if (!args.hasNext()) {
            return tilde;
        }
        return null;
    }

    @Override
    @Nonnull
    public Class<?> getOutputType() {
        return CoordinateArgument.class;
    }
}

