/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.recipes;

import dev.rndmorris.salisarcana.lib.WandHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ConvertInvalidWandRecipe
implements IRecipe {
    public boolean matches(InventoryCrafting inventory, World p_77569_2_) {
        return ConvertInvalidWandRecipe.findInvalidWand(inventory) != null;
    }

    public ItemStack getCraftingResult(InventoryCrafting inventory) {
        WandRod rod;
        ItemStack wandStack = ConvertInvalidWandRecipe.findInvalidWand(inventory);
        if (wandStack == null) {
            return null;
        }
        ItemWandCasting wand = (ItemWandCasting)wandStack.getItem();
        if (wand.getCap(wandStack = wandStack.copy()) == WandHelper.CAP_UNKNOWN) {
            wandStack.stackTagCompound.removeTag("cap");
        }
        if ((rod = wand.getRod(wandStack)) == WandHelper.ROD_UNKNOWN || rod == WandHelper.STAFF_UNKNOWN) {
            wandStack.stackTagCompound.removeTag("rod");
        }
        return wandStack;
    }

    public int getRecipeSize() {
        return 1;
    }

    public ItemStack getRecipeOutput() {
        return null;
    }

    private static ItemStack findInvalidWand(InventoryCrafting inventory) {
        ItemStack wandStack = null;
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack == null) continue;
            if (wandStack != null) {
                return null;
            }
            Item item = stack.getItem();
            if (!(item instanceof ItemWandCasting)) {
                return null;
            }
            ItemWandCasting wand = (ItemWandCasting)item;
            WandCap cap = wand.getCap(stack);
            WandRod rod = wand.getRod(stack);
            if (cap != WandHelper.CAP_UNKNOWN && rod != WandHelper.ROD_UNKNOWN && rod != WandHelper.STAFF_UNKNOWN) {
                return null;
            }
            wandStack = stack;
        }
        return wandStack;
    }
}

