/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.config.settings;

import dev.rndmorris.salisarcana.SalisArcana;
import dev.rndmorris.salisarcana.config.IEnabler;
import dev.rndmorris.salisarcana.config.settings.Setting;
import dev.rndmorris.salisarcana.lib.IntegerHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;

public class BlockItemListSetting<DATA>
extends Setting {
    public final String comment;
    public final String name;
    private ListType listType = ListType.BOTH;
    private final List<String> defaults = new ArrayList<String>();
    private Function<String[], DATA> parser;
    private final Set<ParsedEntry> entriesToResolve = new HashSet<ParsedEntry>();
    private final HashMap<Block, Map<Integer, DATA>> blockMap = new HashMap();
    private final HashMap<Item, Map<Integer, DATA>> itemMap = new HashMap();
    private boolean resolved = false;

    public BlockItemListSetting(IEnabler dependency, String name, String comment) {
        super(dependency);
        this.name = name;
        this.comment = comment;
    }

    public BlockItemListSetting<DATA> withAdditionalData(Function<String[], DATA> parser) {
        this.parser = parser;
        return this;
    }

    @Override
    public void loadFromConfiguration(Configuration configuration) {
        String[] rawEntries;
        for (String rawEntry : rawEntries = configuration.getStringList(this.name, this.getCategory(), this.defaults.toArray(new String[0]), this.comment)) {
            if (rawEntry.trim().isEmpty()) continue;
            ParsedEntry entry = this.parseEntry(rawEntry);
            if (entry == null) {
                SalisArcana.LOG.error("Invalid syntax for {} entry \"{}\"", new Object[]{this.name, rawEntries});
                continue;
            }
            this.entriesToResolve.add(entry);
        }
    }

    public boolean hasEntry(Block block, int metadata) {
        return this.getData((Block)block, (int)metadata).containedKeys;
    }

    public boolean hasEntry(Item item, int metadata) {
        return this.getData((Item)item, (int)metadata).containedKeys;
    }

    @Nonnull
    public GetDataResult getData(Block block, int metadata) {
        if (!this.resolved) {
            this.resolveAllEntries();
        }
        return this.getData(metadata, this.blockMap.get(block));
    }

    @Nonnull
    public GetDataResult getData(Item item, int metadata) {
        if (!this.resolved) {
            this.resolveAllEntries();
        }
        return this.getData(metadata, this.itemMap.get(item));
    }

    @Nonnull
    private GetDataResult getData(int metadata, Map<Integer, DATA> dataMap) {
        if (dataMap == null) {
            return new GetDataResult(false, null);
        }
        if (dataMap.containsKey(metadata)) {
            return new GetDataResult(true, dataMap.get(metadata));
        }
        if (dataMap.containsKey(Short.MAX_VALUE)) {
            return new GetDataResult(true, dataMap.get(Short.MAX_VALUE));
        }
        return new GetDataResult(false, null);
    }

    private void resolveAllEntries() {
        if (this.resolved) {
            return;
        }
        switch (this.listType) {
            case BOTH: {
                this.resolveBothList();
                break;
            }
            case BLOCKS: {
                this.resolveBlockList();
                break;
            }
            case ITEMS: {
                this.resolveItemList();
            }
        }
        this.resolved = true;
        this.entriesToResolve.clear();
    }

    private void resolveBothList() {
        if (this.resolved) {
            return;
        }
        for (ParsedEntry entry : this.entriesToResolve) {
            if (this.tryAddBlock(entry) || this.tryAddItem(entry)) continue;
            SalisArcana.LOG.error("Could not locate a block or item with full id \"{}\".", new Object[]{entry.getFullId()});
        }
    }

    private void resolveBlockList() {
        if (this.resolved) {
            return;
        }
        for (ParsedEntry entry : this.entriesToResolve) {
            if (this.tryAddBlock(entry)) continue;
            SalisArcana.LOG.error("Could not locate a block with full id \"{}\".", new Object[]{entry.getFullId()});
        }
    }

    private void resolveItemList() {
        if (this.resolved) {
            return;
        }
        for (ParsedEntry entry : this.entriesToResolve) {
            if (this.tryAddItem(entry)) continue;
            SalisArcana.LOG.error("Could not locate an item with full id \"{}\".", new Object[]{entry.getFullId()});
        }
    }

    private boolean tryAddBlock(ParsedEntry entry) {
        Block block = this.resolveBlock(entry);
        if (block == null) {
            return false;
        }
        if (block == Blocks.air) {
            this.logAirError();
            return false;
        }
        Map dataMap = this.blockMap.computeIfAbsent(block, k -> new HashMap());
        dataMap.put(entry.metadata, entry.data);
        return true;
    }

    private boolean tryAddItem(ParsedEntry entry) {
        Item item = this.resolveItem(entry);
        if (item == null) {
            return false;
        }
        if (item == Item.getItemFromBlock((Block)Blocks.air)) {
            this.logAirError();
            return false;
        }
        Map dataMap = this.itemMap.computeIfAbsent(item, k -> new HashMap());
        dataMap.put(entry.metadata, entry.data);
        return true;
    }

    private void logAirError() {
        SalisArcana.LOG.error("Attempted to add Air to {}. For technical reasons, this is not allowed.", new Object[]{this.name});
    }

    private Block resolveBlock(ParsedEntry entry) {
        return Block.getBlockFromName((String)entry.getFullId());
    }

    private Item resolveItem(ParsedEntry entry) {
        Object registeredItem = Item.itemRegistry.getObject(entry.getFullId());
        if (!(registeredItem instanceof Item)) {
            return null;
        }
        Item item = (Item)registeredItem;
        return item;
    }

    public BlockItemListSetting<DATA> addDefaults(String ... defaults) {
        Collections.addAll(this.defaults, defaults);
        return this;
    }

    public BlockItemListSetting<DATA> setListType(@Nonnull ListType listType) {
        this.listType = listType;
        return this;
    }

    @Nullable
    private ParsedEntry parseEntry(String rawEntry) {
        String[] parts = rawEntry.split(":");
        if (parts.length < 2) {
            return null;
        }
        ParsedEntry result = new ParsedEntry();
        result.modId = parts[0];
        result.id = parts[1];
        if (parts.length > 2) {
            if ("*".equals(parts[2])) {
                result.metadata = Short.MAX_VALUE;
            } else {
                Integer metadata = IntegerHelper.tryParse(parts[2]);
                if (metadata != null) {
                    result.metadata = metadata;
                }
            }
        }
        if (this.parser != null) {
            result.data = this.parser.apply(parts);
        }
        return result;
    }

    public static enum ListType {
        BOTH,
        BLOCKS,
        ITEMS;

    }

    private class ParsedEntry {
        public String modId;
        public String id;
        public int metadata = 0;
        public DATA data = null;

        private ParsedEntry() {
        }

        public String getFullId() {
            return this.modId + ":" + this.id;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ParsedEntry entry = (ParsedEntry)object;
            return this.metadata == entry.metadata && Objects.equals(this.modId, entry.modId) && Objects.equals(this.id, entry.id);
        }

        public int hashCode() {
            return Objects.hash(this.modId, this.id, this.metadata);
        }
    }

    public class GetDataResult {
        public final boolean containedKeys;
        @Nullable
        public final DATA data;

        private GetDataResult(boolean containedKeys, DATA data) {
            this.containedKeys = containedKeys;
            this.data = data;
        }
    }
}

