/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.config.settings;

import dev.rndmorris.salisarcana.config.IEnabler;
import dev.rndmorris.salisarcana.config.settings.EnumSetting;
import java.util.Random;
import net.minecraft.util.MathHelper;

public class EldritchAltarMobSpawnSetting
extends EnumSetting<Options> {
    public EldritchAltarMobSpawnSetting(IEnabler dependency, String name, String comment) {
        super(dependency, name, comment, Options.DEFAULT, Options.DEFAULT);
    }

    public int randomHorizontal(Random random) {
        int n;
        switch ((Options)this.value) {
            case EVEN_SPREAD: {
                n = this.horizontalEven(random);
                break;
            }
            case CENTER_WEIGHTED: {
                n = this.horizontalWeighted(random);
                break;
            }
            default: {
                throw new RuntimeException(String.format("%s called while its mixin should be disabled.", EldritchAltarMobSpawnSetting.class.getName()));
            }
        }
        return n;
    }

    public int randomVertical(Random random) {
        int n;
        switch ((Options)this.value) {
            case EVEN_SPREAD: {
                n = this.verticalEven(random);
                break;
            }
            case CENTER_WEIGHTED: {
                n = this.verticalWeighted(random);
                break;
            }
            default: {
                throw new RuntimeException(String.format("%s called while its mixin should be disabled.", EldritchAltarMobSpawnSetting.class.getName()));
            }
        }
        return n;
    }

    private int horizontalEven(Random random) {
        return (MathHelper.getRandomIntegerInRange((Random)random, (int)0, (int)6) + 4) * (random.nextBoolean() ? 1 : -1);
    }

    private int verticalEven(Random random) {
        return MathHelper.getRandomIntegerInRange((Random)random, (int)-3, (int)3);
    }

    private int horizontalWeighted(Random random) {
        int val = MathHelper.getRandomIntegerInRange((Random)random, (int)0, (int)6) - MathHelper.getRandomIntegerInRange((Random)random, (int)0, (int)6);
        if (val == 0) {
            return val + 4 * (random.nextBoolean() ? 1 : -1);
        }
        if (val < 0) {
            return val - 4;
        }
        return val + 4;
    }

    private int verticalWeighted(Random random) {
        return MathHelper.getRandomIntegerInRange((Random)random, (int)0, (int)3) - MathHelper.getRandomIntegerInRange((Random)random, (int)0, (int)3);
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.value != Options.DEFAULT;
    }

    public static enum Options {
        DEFAULT,
        EVEN_SPREAD,
        CENTER_WEIGHTED;

    }
}

