/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.lib;

import dev.rndmorris.salisarcana.lib.ResearchHelper;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import thaumcraft.api.research.ScanResult;
import thaumcraft.common.lib.research.ScanManager;

public class InventoryHelper {
    public static ArrayList<ItemStack> getItemStacks(IInventory inventory) {
        return InventoryHelper.getItemStacks(inventory, null);
    }

    public static ArrayList<ItemStack> getItemStacks(IInventory inventory, @Nullable Predicate<ItemStack> predicate) {
        Objects.requireNonNull(inventory);
        ArrayList<ItemStack> output = new ArrayList<ItemStack>(inventory.getSizeInventory());
        for (int index = 0; index < inventory.getSizeInventory(); ++index) {
            ItemStack item = inventory.getStackInSlot(index);
            if (item == null || predicate != null && !predicate.test(item)) continue;
            output.add(item);
        }
        return output;
    }

    public static void scanInventory(IInventory inventory, EntityPlayer player) {
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack item = inventory.getStackInSlot(i);
            if (item == null) continue;
            ScanResult result = new ScanResult(1, Item.getIdFromItem((Item)item.getItem()), item.getItemDamage(), null, "");
            if (ResearchHelper.isItemScanned(player, item, "@")) continue;
            ScanManager.completeScan((EntityPlayer)player, (ScanResult)result, (String)"@");
        }
    }
}

