/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.lib;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import dev.rndmorris.salisarcana.api.IResearchItemExtended;
import dev.rndmorris.salisarcana.common.commands.ArcanaCommandBase;
import dev.rndmorris.salisarcana.common.commands.PrerequisitesCommand;
import dev.rndmorris.salisarcana.config.SalisConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.FakePlayer;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.playerdata.PacketPlayerCompleteToServer;
import thaumcraft.common.lib.research.ScanManager;

public class ResearchHelper {
    public static boolean matchesTerm(ResearchItem research, String searchTerm) {
        searchTerm = searchTerm.toLowerCase();
        return research.key.toLowerCase().contains(searchTerm) || research.getName().toLowerCase().contains(searchTerm);
    }

    public static Collection<IChatComponent> printResearchToChat(Predicate<ResearchItem> filter) {
        ArrayList<IChatComponent> results = new ArrayList<IChatComponent>();
        for (Map.Entry entry : ResearchCategories.researchCategories.entrySet()) {
            ResearchCategoryList category = (ResearchCategoryList)entry.getValue();
            ChatComponentText researchMessage = new ChatComponentText("");
            boolean anyInCategory = false;
            for (ResearchItem research : category.research.values()) {
                if (!filter.test(research)) continue;
                if (anyInCategory) {
                    researchMessage.appendText(", ");
                }
                anyInCategory = true;
                researchMessage.appendSibling(ResearchHelper.formatResearch(research));
            }
            if (!anyInCategory) continue;
            results.add(ResearchHelper.categoryMessage((String)entry.getKey()));
            results.add((IChatComponent)researchMessage);
        }
        return results;
    }

    private static IChatComponent categoryMessage(String categoryKey) {
        ChatStyle style = new ChatStyle();
        style.setBold(Boolean.valueOf(true));
        style.setColor(EnumChatFormatting.BLUE);
        style.setChatHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(categoryKey)));
        ChatComponentTranslation headerMessage = new ChatComponentTranslation("salisarcana:command.category_header", new Object[]{ResearchCategories.getCategoryName((String)categoryKey)});
        headerMessage.setChatStyle(style);
        return headerMessage;
    }

    public static void sendResearchError(EntityPlayer player, String researchKey, String translationKey) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (!(player instanceof FakePlayer)) {
                ChatComponentText researchName;
                ResearchItem research = ResearchCategories.getResearch((String)researchKey);
                if (research instanceof IResearchItemExtended) {
                    IResearchItemExtended extended = (IResearchItemExtended)research;
                    researchName = new ChatComponentTranslation(extended.getNameTranslationKey(), new Object[0]);
                } else {
                    researchName = new ChatComponentText(research.getName());
                }
                ChatComponentTranslation message = new ChatComponentTranslation(translationKey, new Object[]{researchName, new ChatComponentTranslation("tc.research_category." + research.category, new Object[0])});
                message.setChatStyle(new ChatStyle().setColor(EnumChatFormatting.RED));
                playerMP.addChatMessage((IChatComponent)message);
            }
        }
    }

    public static IChatComponent formatResearch(ResearchItem research) {
        return ResearchHelper.formatResearch(research, EnumChatFormatting.DARK_PURPLE);
    }

    public static IChatComponent formatResearch(ResearchItem research, EnumChatFormatting formatting) {
        String string;
        if (research instanceof IResearchItemExtended) {
            IResearchItemExtended extended = (IResearchItemExtended)research;
            string = extended.getNameTranslationKey();
        } else {
            string = String.format("tc.research_name.%s", research.key);
        }
        String researchKeyName = string;
        ChatStyle style = new ChatStyle().setColor(formatting).setChatHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(research.key)));
        return new ChatComponentText("[").setChatStyle(style).appendSibling((IChatComponent)new ChatComponentTranslation(researchKeyName, new Object[0])).appendText("]");
    }

    public static IChatComponent formatResearchClickCommand(ResearchItem research) {
        IChatComponent result = ResearchHelper.formatResearch(research);
        result.getChatStyle().setChatClickEvent(ResearchHelper.suggestResearchCommandOnClick(research));
        return result;
    }

    public static IChatComponent formatResearchClickCommand(ResearchItem research, EnumChatFormatting formatting) {
        IChatComponent result = ResearchHelper.formatResearch(research, formatting);
        result.getChatStyle().setChatClickEvent(ResearchHelper.suggestResearchCommandOnClick(research));
        return result;
    }

    public static ClickEvent suggestResearchCommandOnClick(ResearchItem research) {
        ArcanaCommandBase<?> arcanaCommandBase;
        if (SalisConfig.commands.prerequisites.isEnabled() && (arcanaCommandBase = SalisConfig.commands.prerequisites.getCommand()) instanceof PrerequisitesCommand) {
            PrerequisitesCommand command = (PrerequisitesCommand)arcanaCommandBase;
            return new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, String.format("/%s --research %s", command.getCommandName(), research.key));
        }
        return null;
    }

    public static void completeResearchClient(EntityPlayer player, String research) {
        if (!player.worldObj.isRemote) {
            return;
        }
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketPlayerCompleteToServer(research, player.getCommandSenderName(), player.worldObj.provider.dimensionId, 0));
    }

    public static boolean isItemScanned(EntityPlayer player, ItemStack stack, String prefix) {
        Item item = stack.getItem();
        int meta = stack.getItemDamage();
        Map scannedObjects = Thaumcraft.proxy.getScannedObjects();
        ArrayList scanned = (ArrayList)scannedObjects.get(player.getCommandSenderName());
        if (scanned == null) {
            return false;
        }
        String hash = prefix + ScanManager.generateItemHash((Item)item, (int)meta);
        return scanned.contains(hash);
    }

    public static boolean hasResearchAspects(String username, AspectList aspects) {
        AspectList playerAspects = Thaumcraft.proxy.playerKnowledge.getAspectsDiscovered(username);
        for (Map.Entry aspect : aspects.aspects.entrySet()) {
            if (playerAspects.getAmount((Aspect)aspect.getKey()) >= (Integer)aspect.getValue()) continue;
            return false;
        }
        return true;
    }
}

