/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.lib.recipe;

import java.util.ArrayList;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.blocks.ItemJarFilled;
import thaumcraft.common.config.ConfigBlocks;

public class EmptyJarRecipe
implements IRecipe {
    public boolean matches(InventoryCrafting inventory, World world) {
        ArrayList<ItemStack> stacks = this.getStacks(inventory);
        if (stacks.size() != 1) {
            return false;
        }
        ItemStack itemStack = stacks.get(0);
        return itemStack.getItem() instanceof ItemJarFilled;
    }

    public ItemStack getCraftingResult(InventoryCrafting inventory) {
        ArrayList<ItemStack> stacks = this.getStacks(inventory);
        ItemStack stack = stacks.get(0);
        Item item = stack.getItem();
        if (item instanceof ItemJarFilled) {
            ItemStack emptyJar;
            ItemJarFilled jar = (ItemJarFilled)item;
            Aspect filter = jar.getFilter(stack);
            if (filter != null) {
                emptyJar = new ItemStack((Item)jar, 1, stack.getItemDamage());
                emptyJar.setTagCompound(new NBTTagCompound());
                emptyJar.getTagCompound().setString("AspectFilter", filter.getTag());
            } else {
                emptyJar = new ItemStack(ConfigBlocks.blockJar, 1, stack.getItemDamage());
            }
            return emptyJar;
        }
        return null;
    }

    public int getRecipeSize() {
        return 1;
    }

    public ItemStack getRecipeOutput() {
        return null;
    }

    private ArrayList<ItemStack> getStacks(InventoryCrafting inventory) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack == null || stack.getItem() == null) continue;
            stacks.add(stack);
        }
        return stacks;
    }
}

