/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.lib.recipe;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public final class MundaneRepairRecipe
implements IRecipe {
    public static final MundaneRepairRecipe INSTANCE = new MundaneRepairRecipe();

    public boolean matches(InventoryCrafting inv, World world) {
        return this.getCraftingResult(inv) != null;
    }

    public ItemStack getCraftingResult(InventoryCrafting inv) {
        ItemStack toolOne = null;
        ItemStack toolTwo = null;
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null) continue;
            if (stack.stackSize != 1) {
                return null;
            }
            if (toolOne == null) {
                toolOne = stack;
                if (stack.getItem().isRepairable()) continue;
                return null;
            }
            if (toolTwo == null) {
                toolTwo = stack;
                if (toolOne.getItem() == toolTwo.getItem()) continue;
                return null;
            }
            return null;
        }
        if (toolTwo != null) {
            Item item = toolOne.getItem();
            int maxDamage = item.getMaxDamage();
            int durability = maxDamage - toolOne.getItemDamageForDisplay();
            durability += maxDamage - toolTwo.getItemDamageForDisplay();
            return new ItemStack(item, 1, Math.max(0, maxDamage - (durability += maxDamage / 20)));
        }
        return null;
    }

    public int getRecipeSize() {
        return 2;
    }

    public ItemStack getRecipeOutput() {
        return null;
    }
}

