/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.mixins.late.items;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import dev.rndmorris.salisarcana.config.SalisConfig;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import thaumcraft.api.IArchitect;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.items.wands.foci.ItemFocusTrade;

@Mixin(value={ItemFocusTrade.class}, remap=false)
public abstract class MixinItemFocusTrade_HarvestLevel
extends ItemFocusBasic
implements IArchitect {
    @Unique
    private final int sa$harvestLevel;
    @Unique
    private final boolean sa$potencyEnabled;
    @Unique
    private long sa$lastPlayedSound;
    @Unique
    private boolean sa$rightClick;

    public MixinItemFocusTrade_HarvestLevel() {
        this.sa$harvestLevel = SalisConfig.features.equalTradeFocusHarvestLevel.getValue();
        this.sa$potencyEnabled = SalisConfig.features.potencyModifiesHarvestLevel.isEnabled();
        this.sa$rightClick = false;
    }

    @Shadow
    protected abstract MovingObjectPosition getMovingObjectPositionFromPlayer(World var1, EntityPlayer var2);

    @Shadow
    public abstract boolean onEntitySwing(EntityLivingBase var1, ItemStack var2);

    @WrapMethod(method={"onFocusRightClick"})
    public ItemStack wrapOnFocusRightClick(ItemStack itemstack, World world, EntityPlayer player, MovingObjectPosition mop, Operation<ItemStack> original) {
        this.sa$rightClick = true;
        return (ItemStack)original.call(new Object[]{itemstack, world, player, mop});
    }

    @WrapOperation(method={"onFocusRightClick"}, at={@At(value="INVOKE", target="Lthaumcraft/common/items/wands/foci/ItemFocusTrade;getPickedBlock(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;")})
    private ItemStack wrapGetPickedBlock(ItemFocusTrade instance, ItemStack stack, Operation<ItemStack> original, @Local(name={"player"}) EntityPlayer player) {
        if (this.sa$shouldBreak(stack, player)) {
            return (ItemStack)original.call(new Object[]{instance, stack});
        }
        this.onEntitySwing((EntityLivingBase)player, stack);
        return null;
    }

    @WrapOperation(method={"onEntitySwing"}, at={@At(value="INVOKE", target="Lthaumcraft/common/items/wands/foci/ItemFocusTrade;getPickedBlock(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;")})
    public ItemStack wrapOnEntitySwing(ItemFocusTrade instance, ItemStack stack, Operation<ItemStack> original, @Local(name={"player"}) EntityLivingBase player) {
        if (this.sa$shouldBreak(stack, (EntityPlayer)player) || this.sa$rightClick && player.isSneaking() || !(stack.getItem() instanceof ItemWandCasting)) {
            this.sa$rightClick = false;
            return (ItemStack)original.call(new Object[]{instance, stack});
        }
        if (player.isClientWorld() && System.currentTimeMillis() - this.sa$lastPlayedSound > 500L) {
            this.sa$lastPlayedSound = System.currentTimeMillis();
            player.worldObj.playSoundEffect(player.posX, player.posY, player.posZ, "thaumcraft:craftfail", 1.0f, 1.0f);
        }
        this.sa$rightClick = false;
        return null;
    }

    @Unique
    public boolean sa$shouldBreak(ItemStack stack, EntityPlayer player) {
        World world = player.worldObj;
        MovingObjectPosition mop = this.getMovingObjectPositionFromPlayer(world, player);
        if (mop == null) {
            return true;
        }
        int x = mop.blockX;
        int y = mop.blockY;
        int z = mop.blockZ;
        Block block = world.getBlock(x, y, z);
        if (block == null) {
            return true;
        }
        int metadata = world.getBlockMetadata(x, y, z);
        if (block.hasTileEntity(metadata)) {
            return false;
        }
        int harvestLevel = this.sa$harvestLevel;
        if (this.sa$potencyEnabled) {
            Item item = stack.getItem();
            if (item instanceof ItemWandCasting) {
                ItemWandCasting wand = (ItemWandCasting)item;
                ItemStack focus = wand.getFocusItem(stack);
                harvestLevel += this.getUpgradeLevel(focus, FocusUpgradeType.potency);
            } else {
                return false;
            }
        }
        return block.getHarvestLevel(metadata) <= harvestLevel;
    }
}

