/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.mixins.late.items;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import thaumcraft.common.items.ItemKey;
import thaumcraft.common.tiles.TileOwned;

@Mixin(value={ItemKey.class})
public class MixinItemKey_ExtraSecurityChecks {
    @ModifyExpressionValue(method={"onItemUseFirst"}, at={@At(value="NEW", target="(Lnet/minecraft/item/Item;II)Lnet/minecraft/item/ItemStack;")})
    public ItemStack addExtraSecurityInfo(ItemStack key, @Local(argsOnly=true) EntityPlayer player, @Local(argsOnly=true) World world) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.setString("salisarcana:creator", player.getCommandSenderName());
        nbt.setInteger("salisarcana:dimension", world.provider.dimensionId);
        key.setTagCompound(nbt);
        return key;
    }

    @WrapOperation(method={"onItemUseFirst"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/NBTTagCompound;getString(Ljava/lang/String;)Ljava/lang/String;")})
    public String checkExtraSecurityInfo(NBTTagCompound tag, String nbtKey, Operation<String> original, @Local TileEntity tileEntity, @Local(argsOnly=true) World world, @Local(argsOnly=true) ItemStack key) {
        String creator = tag.getString("salisarcana:creator");
        if (!creator.isEmpty()) {
            if (tag.getInteger("salisarcana:dimension") != world.provider.dimensionId) {
                return null;
            }
            TileOwned tile = (TileOwned)tileEntity;
            if (!(creator.equals(tile.owner) || key.getItemDamage() == 0 && tile.accessList.contains("1" + creator))) {
                return null;
            }
        }
        return (String)original.call(new Object[]{tag, nbtKey});
    }

    @Inject(method={"addInformation"}, at={@At(value="TAIL")})
    public void addExtraInfo(ItemStack key, EntityPlayer player, List<String> text, boolean advancedTooltips, CallbackInfo ci) {
        if (key.hasTagCompound() && key.stackTagCompound.hasKey("salisarcana:creator")) {
            int lastLine = text.size() - 1;
            String dimInfo = StatCollector.translateToLocalFormatted((String)"salisarcana:misc.arcane_key.dimension", (Object[])new Object[]{key.stackTagCompound.getInteger("salisarcana:dimension")});
            text.set(lastLine, text.get(lastLine) + dimInfo);
            text.add(StatCollector.translateToLocalFormatted((String)"salisarcana:misc.arcane_key.creator", (Object[])new Object[]{key.stackTagCompound.getString("salisarcana:creator")}));
        }
    }
}

