/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.mixins.late.tiles;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import thaumcraft.common.tiles.TileEtherealBloom;

@Mixin(value={TileEtherealBloom.class}, remap=false)
public class MixinTileEtherealBloom
extends TileEntity {
    @Shadow
    public int counter;
    @Shadow
    public int growthCounter;

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.counter = compound.getByte("salisarcana:counter");
        this.growthCounter = compound.getByte("salisarcana:growthCounter");
        this.counter %= 160;
        this.growthCounter = Math.min(101, this.growthCounter);
    }

    public void writeToNBT(NBTTagCompound compound) {
        this.counter %= 160;
        this.growthCounter = Math.min(101, this.growthCounter);
        compound.setByte("salisarcana:counter", (byte)this.counter);
        compound.setByte("salisarcana:growthCounter", (byte)this.growthCounter);
        super.writeToNBT(compound);
    }

    @Nullable
    public Packet getDescriptionPacket() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, this.getBlockMetadata(), nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readFromNBT(pkt.func_148857_g());
    }
}

