/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.mixins.late.tiles;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.rndmorris.salisarcana.lib.TimeHelper;
import dev.rndmorris.salisarcana.lib.ifaces.IGameTimeNode;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.common.tiles.TileNode;

@Mixin(value={TileNode.class})
public abstract class MixinTileNode_RechargeTime
extends TileThaumcraft
implements IGameTimeNode {
    @Unique
    long sa$lastTickActive = -1L;

    @Shadow(remap=false)
    public abstract NodeModifier getNodeModifier();

    @WrapMethod(method={"writeToNBT"})
    private void writeToNBT(NBTTagCompound nbttagcompound, Operation<Void> original) {
        original.call(new Object[]{nbttagcompound});
        if (this.sa$lastTickActive >= 0L) {
            nbttagcompound.setLong("salisarcana:lastTickActive", this.sa$lastTickActive);
        }
    }

    @WrapMethod(method={"readFromNBT"})
    private void readFromNBT(NBTTagCompound nbttagcompound, Operation<Void> original) {
        original.call(new Object[]{nbttagcompound});
        if (nbttagcompound.hasKey("salisarcana:lastTickActive", 4)) {
            this.sa$lastTickActive = nbttagcompound.getLong("salisarcana:lastTickActive");
        }
    }

    @WrapOperation(method={"handleRecharge"}, remap=false, at={@At(value="FIELD", target="Lthaumcraft/common/tiles/TileNode;catchUp:Z", opcode=180)})
    private boolean shouldCatchUp(TileNode instance, Operation<Boolean> original) {
        boolean catchUp = (Boolean)original.call(new Object[]{instance});
        if (this.sa$lastTickActive < 0L) {
            return catchUp;
        }
        if (!catchUp) {
            return false;
        }
        long regenRate = this.sa$regenRate();
        long regenInterval = regenRate * 75L;
        long worldTime = this.worldObj.getTotalWorldTime();
        return regenRate > 0L && TimeHelper.ticksToMs(worldTime) > this.sa$lastTickActive + regenInterval;
    }

    @WrapOperation(method={"handleRecharge"}, remap=false, at={@At(value="INVOKE", target="Ljava/lang/System;currentTimeMillis()J", ordinal=0)})
    private long captureCurrentTimeForRegen(Operation<Long> original) {
        return this.sa$lastTickActive >= 0L ? TimeHelper.ticksToMs(this.worldObj.getTotalWorldTime()) : (Long)original.call(new Object[0]);
    }

    @WrapOperation(method={"handleRecharge"}, remap=false, at={@At(value="FIELD", target="Lthaumcraft/common/tiles/TileNode;lastActive:J", opcode=180)})
    private long captureLastActiveForRegen(TileNode instance, Operation<Long> original) {
        return this.sa$lastTickActive >= 0L ? TimeHelper.ticksToMs(this.sa$lastTickActive) : (Long)original.call(new Object[]{instance});
    }

    @WrapOperation(method={"handleRecharge"}, remap=false, at={@At(value="FIELD", target="Lthaumcraft/common/tiles/TileNode;lastActive:J", opcode=181)})
    private void captureCurrentTimeForStorage(TileNode instance, long value, Operation<Void> original) {
        original.call(new Object[]{instance, value});
        this.sa$updateLastTickActive();
    }

    @Unique
    private long sa$regenRate() {
        long l;
        NodeModifier modifier = this.getNodeModifier();
        if (modifier == null) {
            return 600L;
        }
        switch (modifier) {
            case BRIGHT: {
                l = 400L;
                break;
            }
            case PALE: {
                l = 900L;
                break;
            }
            case FADING: {
                l = 0L;
                break;
            }
            default: {
                l = 600L;
            }
        }
        return l;
    }

    @Override
    public void sa$updateLastTickActive() {
        this.sa$lastTickActive = this.worldObj.getTotalWorldTime();
    }
}

