/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import dev.rndmorris.salisarcana.config.SalisConfig;
import dev.rndmorris.salisarcana.lib.ResearchHelper;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.lib.research.ResearchManager;

public class MessageDuplicateResearch
implements IMessage,
IMessageHandler<MessageDuplicateResearch, IMessage> {
    private String key;

    public MessageDuplicateResearch() {
    }

    public MessageDuplicateResearch(String key) {
        this.key = key;
    }

    public void fromBytes(ByteBuf buf) {
        int length = buf.readInt();
        byte[] bytes = new byte[length];
        buf.readBytes(bytes);
        this.key = new String(bytes, StandardCharsets.UTF_8);
    }

    public void toBytes(ByteBuf buf) {
        byte[] bytes = this.key.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(bytes.length);
        buf.writeBytes(bytes);
    }

    public IMessage onMessage(MessageDuplicateResearch message, MessageContext ctx) {
        ItemStack note;
        boolean freeAspects;
        if (!SalisConfig.features.nomiconDuplicateResearch.isEnabled()) {
            return null;
        }
        EntityPlayerMP player = ctx.getServerHandler().playerEntity;
        String username = player.getCommandSenderName();
        boolean freeScribestuff = SalisConfig.features.creativeOpThaumonomicon.isEnabled() && player.capabilities.isCreativeMode;
        boolean bl = freeAspects = freeScribestuff || SalisConfig.features.researchDuplicationFree.isEnabled();
        if (!ResearchManager.isResearchComplete((String)username, (String)message.key) || !ResearchManager.isResearchComplete((String)username, (String)"RESEARCHDUPE")) {
            return null;
        }
        AspectList aspectPrice = null;
        if (!freeAspects && !ResearchHelper.hasResearchAspects(username, aspectPrice = ResearchCategories.getResearch((String)message.key).tags)) {
            return null;
        }
        if (!freeScribestuff) {
            if (!ResearchManager.consumeInkFromPlayer((EntityPlayer)player, (boolean)false)) {
                return null;
            }
            if (!player.inventory.consumeInventoryItem(Items.paper)) {
                return null;
            }
            ResearchManager.consumeInkFromPlayer((EntityPlayer)player, (boolean)true);
        }
        if (!freeAspects) {
            AspectList playerAspects = Thaumcraft.proxy.playerKnowledge.getAspectsDiscovered(username);
            for (Map.Entry aspect : aspectPrice.aspects.entrySet()) {
                playerAspects.reduce((Aspect)aspect.getKey(), ((Integer)aspect.getValue()).intValue());
            }
        }
        if ((note = ResearchManager.createNote((ItemStack)new ItemStack(ConfigItems.itemResearchNotes, 1, 64), (String)message.key, (World)player.worldObj)) != null) {
            note.getTagCompound().setBoolean("complete", true);
            if (!player.inventory.addItemStackToInventory(note)) {
                player.dropPlayerItemWithRandomChoice(note, false);
            }
            player.worldObj.playSoundAtEntity((Entity)player, "thaumcraft:learn", 0.75f, 1.0f);
        }
        player.inventoryContainer.detectAndSendChanges();
        return null;
    }
}

