/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import org.apache.commons.lang3.BitField;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.research.PlayerKnowledge;

public class MessageForgetScannedCategory
implements IMessage,
IMessageHandler<MessageForgetScannedCategory, IMessage> {
    private final BitField objectsMask = new BitField(1);
    private final BitField entitiesMask = new BitField(2);
    private final BitField nodesMask = new BitField(4);
    private int categories = 0;

    public MessageForgetScannedCategory() {
    }

    public MessageForgetScannedCategory(boolean objects, boolean entities, boolean nodes) {
        int categories = 0;
        if (objects) {
            categories = this.objectsMask.set(categories);
        }
        if (entities) {
            categories = this.entitiesMask.set(categories);
        }
        if (nodes) {
            categories = this.nodesMask.set(categories);
        }
        this.categories = categories;
    }

    public void fromBytes(ByteBuf buf) {
        this.categories = buf.readByte();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.categories);
    }

    public IMessage onMessage(MessageForgetScannedCategory message, MessageContext ctx) {
        if (message.categories == 0) {
            return null;
        }
        int categories = message.categories;
        PlayerKnowledge knowledge = Thaumcraft.proxy.getPlayerKnowledge();
        String playerName = Minecraft.getMinecraft().thePlayer.getCommandSenderName();
        if (this.objectsMask.isSet(categories)) {
            this.clearScanMap(playerName, knowledge.objectsScanned);
        }
        if (this.entitiesMask.isSet(categories)) {
            this.clearScanMap(playerName, knowledge.entitiesScanned);
        }
        if (this.nodesMask.isSet(categories)) {
            this.clearScanMap(playerName, knowledge.phenomenaScanned);
        }
        return null;
    }

    private void clearScanMap(String playerName, Map<String, ArrayList<String>> map) {
        ArrayList<String> scannedList = map.get(playerName);
        if (scannedList != null) {
            scannedList.clear();
        }
    }
}

