/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import dev.rndmorris.salisarcana.config.SalisConfig;
import dev.rndmorris.salisarcana.lib.InventoryHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.playerdata.PacketSyncScannedItems;
import thaumcraft.common.lib.research.ResearchManager;

public class MessageScanContainer
implements IMessage,
IMessageHandler<MessageScanContainer, IMessage> {
    public int x;
    public int y;
    public int z;

    public MessageScanContainer() {
    }

    public MessageScanContainer(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public IMessage onMessage(MessageScanContainer message, MessageContext ctx) {
        EntityPlayerMP entityPlayer = ctx.getServerHandler().playerEntity;
        if (SalisConfig.features.thaumometerScanContainersResearch.isEnabled() && !ResearchManager.isResearchComplete((String)entityPlayer.getCommandSenderName(), (String)SalisConfig.features.thaumometerScanContainersResearch.getInternalName())) {
            return null;
        }
        World world = entityPlayer.worldObj;
        TileEntity tile = world.getTileEntity(message.x, message.y, message.z);
        if (tile instanceof IInventory) {
            IInventory inventory = (IInventory)tile;
            InventoryHelper.scanInventory(inventory, (EntityPlayer)entityPlayer);
        }
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncScannedItems((EntityPlayer)ctx.getServerHandler().playerEntity), ctx.getServerHandler().playerEntity);
        return null;
    }
}

