/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.mixins.late.items;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import dev.rndmorris.salisarcana.config.SalisConfig;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import thaumcraft.api.IArchitect;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.items.wands.foci.ItemFocusTrade;

@Mixin(value={ItemFocusTrade.class}, remap=false)
public abstract class MixinItemFocusTrade_HarvestLevel
extends ItemFocusBasic
implements IArchitect {
    @Unique
    private final int sa$harvestLevel;
    @Unique
    private final boolean sa$potencyEnabled;
    @Unique
    private long sa$lastPlayedSound;
    @Unique
    private boolean sa$rightClick;

    public MixinItemFocusTrade_HarvestLevel() {
        this.sa$harvestLevel = SalisConfig.features.equalTradeFocusHarvestLevel.getValue();
        this.sa$potencyEnabled = SalisConfig.features.potencyModifiesHarvestLevel.isEnabled();
        this.sa$rightClick = false;
    }

    @Shadow
    protected abstract MovingObjectPosition getMovingObjectPositionFromPlayer(World var1, EntityPlayer var2);

    @Shadow
    public abstract boolean onEntitySwing(EntityLivingBase var1, ItemStack var2);

    @WrapMethod(method={"onFocusRightClick"})
    public ItemStack wrapOnFocusRightClick(ItemStack itemstack, World world, EntityPlayer player, MovingObjectPosition mop, Operation<ItemStack> original) {
        this.sa$rightClick = true;
        return (ItemStack)original.call(new Object[]{itemstack, world, player, mop});
    }

    @WrapOperation(method={"onFocusRightClick"}, at={@At(value="INVOKE", target="Lthaumcraft/common/items/wands/foci/ItemFocusTrade;getPickedBlock(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;")})
    private ItemStack wrapGetPickedBlock(ItemFocusTrade instance, ItemStack stack, Operation<ItemStack> original, @Local(name={"player"}) EntityPlayer player) {
        if (this.sa$shouldBreak(stack, player)) {
            return (ItemStack)original.call(new Object[]{instance, stack});
        }
        this.onEntitySwing((EntityLivingBase)player, stack);
        return null;
    }

    @WrapOperation(method={"onEntitySwing"}, at={@At(value="INVOKE", target="Lthaumcraft/common/items/wands/foci/ItemFocusTrade;getPickedBlock(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;")})
    public ItemStack wrapOnEntitySwing(ItemFocusTrade instance, ItemStack stack, Operation<ItemStack> original, @Local(name={"player"}) EntityLivingBase player) {
        if (this.sa$shouldBreak(stack, (EntityPlayer)player) || this.sa$rightClick && player.func_70093_af() || !(stack.func_77973_b() instanceof ItemWandCasting)) {
            this.sa$rightClick = false;
            return (ItemStack)original.call(new Object[]{instance, stack});
        }
        if (player.func_70613_aW() && System.currentTimeMillis() - this.sa$lastPlayedSound > 500L) {
            this.sa$lastPlayedSound = System.currentTimeMillis();
            player.field_70170_p.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "thaumcraft:craftfail", 1.0f, 1.0f);
        }
        this.sa$rightClick = false;
        return null;
    }

    @Unique
    public boolean sa$shouldBreak(ItemStack stack, EntityPlayer player) {
        World world = player.field_70170_p;
        MovingObjectPosition mop = this.getMovingObjectPositionFromPlayer(world, player);
        if (mop == null) {
            return true;
        }
        int x = mop.field_72311_b;
        int y = mop.field_72312_c;
        int z = mop.field_72309_d;
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            return true;
        }
        int metadata = world.func_72805_g(x, y, z);
        if (block.hasTileEntity(metadata)) {
            return false;
        }
        int harvestLevel = this.sa$harvestLevel;
        if (this.sa$potencyEnabled) {
            Item item = stack.func_77973_b();
            if (item instanceof ItemWandCasting) {
                ItemWandCasting wand = (ItemWandCasting)item;
                ItemStack focus = wand.getFocusItem(stack);
                harvestLevel += this.getUpgradeLevel(focus, FocusUpgradeType.potency);
            } else {
                return false;
            }
        }
        return block.getHarvestLevel(metadata) <= harvestLevel;
    }
}

