/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.research.PlayerKnowledge;

public class MessageForgetScannedObjects
implements IMessage,
IMessageHandler<MessageForgetScannedObjects, IMessage> {
    private HashSet<Integer> forgetHashes;

    public MessageForgetScannedObjects() {
    }

    public MessageForgetScannedObjects(Collection<Integer> forgetHashes) {
        this.forgetHashes = new HashSet(forgetHashes.size());
        this.forgetHashes.addAll(forgetHashes);
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.forgetHashes = new HashSet(size);
        for (int count = 0; count < size; ++count) {
            this.forgetHashes.add(buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.forgetHashes.size());
        for (Integer hash : this.forgetHashes) {
            buf.writeInt(hash.intValue());
        }
    }

    public IMessage onMessage(MessageForgetScannedObjects message, MessageContext ctx) {
        PlayerKnowledge knowledge = Thaumcraft.proxy.getPlayerKnowledge();
        String playerName = Minecraft.func_71410_x().field_71439_g.func_70005_c_();
        ArrayList objectsScanned = (ArrayList)knowledge.objectsScanned.get(playerName);
        if (objectsScanned == null || objectsScanned.size() == 0) {
            return null;
        }
        for (Integer hash : message.forgetHashes) {
            String key = "@" + hash;
            objectsScanned.remove(key);
        }
        return null;
    }
}

