/*
 * Decompiled with CFR 0.152.
 */
package net.dyrohc.cravings;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="cravings", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigFileCravings {
    public static final ForgeConfigSpec SERVER_CONFIG;
    public static final Server SERVER;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            ConfigFileCravings.apply();
        }
    }

    @SubscribeEvent
    public static void onReloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            ConfigFileCravings.apply();
        }
    }

    public static void apply() {
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        SERVER = new Server(builder);
        SERVER_CONFIG = builder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG, "Cravings/cravings-effects.toml");
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue CFG_sweet_xp_amount;
        public final ForgeConfigSpec.DoubleValue CFG_sweet_saturation_amount;
        public final ForgeConfigSpec.IntValue CFG_sweet_speed_level;
        public final ForgeConfigSpec.IntValue CFG_sweet_speed_duration;
        public final ForgeConfigSpec.IntValue CFG_healthy_xp_amount;
        public final ForgeConfigSpec.DoubleValue CFG_healthy_saturation_amount;
        public final ForgeConfigSpec.IntValue CFG_healthy_haste_level;
        public final ForgeConfigSpec.IntValue CFG_healthy_haste_duration;
        public final ForgeConfigSpec.IntValue CFG_meaty_xp_amount;
        public final ForgeConfigSpec.DoubleValue CFG_meaty_saturation_amount;
        public final ForgeConfigSpec.IntValue CFG_meaty_strength_level;
        public final ForgeConfigSpec.IntValue CFG_meaty_strength_duration;
        public final ForgeConfigSpec.IntValue CFG_fishy_xp_amount;
        public final ForgeConfigSpec.DoubleValue CFG_fishy_saturation_amount;
        public final ForgeConfigSpec.IntValue CFG_fishy_wbreathing_duration;
        public final ForgeConfigSpec.IntValue CFG_gross_xp_amount;
        public final ForgeConfigSpec.DoubleValue CFG_gross_saturation_amount;
        public final ForgeConfigSpec.IntValue CFG_gross_resistance_level;
        public final ForgeConfigSpec.IntValue CFG_gross_resistance_duration;
        public final ForgeConfigSpec.IntValue CFG_fancy_xp_amount;
        public final ForgeConfigSpec.DoubleValue CFG_fancy_saturation_amount;
        public final ForgeConfigSpec.IntValue CFG_fancy_nvision_duration;
        public final ForgeConfigSpec.IntValue CFG_hearty_xp_amount;
        public final ForgeConfigSpec.DoubleValue CFG_hearty_saturation_amount;
        public final ForgeConfigSpec.IntValue CFG_hearty_hboost_level;
        public final ForgeConfigSpec.IntValue CFG_hearty_hboost_duration;
        public final ForgeConfigSpec.IntValue CFG_raw_xp_amount;
        public final ForgeConfigSpec.DoubleValue CFG_raw_saturation_amount;
        public final ForgeConfigSpec.IntValue CFG_raw_nausea_duration;
        public final ForgeConfigSpec.DoubleValue CFG_saturation_loss;
        public final ForgeConfigSpec.IntValue CFG_hunger_duration;
        public final ForgeConfigSpec.IntValue CFG_hunger_level;
        public final ForgeConfigSpec.IntValue CFG_slowness_duration;
        public final ForgeConfigSpec.IntValue CFG_slowness_level;
        public final ForgeConfigSpec.IntValue CFG_mining_fatigue_duration;
        public final ForgeConfigSpec.IntValue CFG_mining_fatigue_level;
        public final ForgeConfigSpec.IntValue CFG_weakness_duration;
        public final ForgeConfigSpec.IntValue CFG_weakness_level;
        public final ForgeConfigSpec.IntValue CFG_nausea_duration;
        public final ForgeConfigSpec.IntValue CFG_blindness_duration;
        public final ForgeConfigSpec.IntValue CFG_hunger_hearty_duration;
        public final ForgeConfigSpec.IntValue CFG_hunger_hearty_level;
        public final ForgeConfigSpec.IntValue CFG_luck_duration;
        public final ForgeConfigSpec.IntValue CFG_luck_level;

        Server(ForgeConfigSpec.Builder builder) {
            builder.push("Sweet Craving Settings");
            this.CFG_sweet_xp_amount = builder.comment("XP points awarded when satisfying the Sweet craving. (Default: 3)").defineInRange("Sweet XP Amount", 3, 0, Integer.MAX_VALUE);
            this.CFG_sweet_saturation_amount = builder.comment("Extra saturation points gained when satisfying the Sweet craving. (Default: 1)").defineInRange("Sweet Saturation Amount", 1.0, 0.0, 20.0);
            this.CFG_sweet_speed_level = builder.comment("Speed effect level applied when satisfying the Sweet craving. (Default: 1)").defineInRange("Sweet Speed Level", 1, 1, 255);
            this.CFG_sweet_speed_duration = builder.comment("Duration (in ticks) of the Speed effect when satisfying the Sweet craving. (Default: 6000)").defineInRange("Sweet Speed Duration", 6000, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Healthy Craving Settings");
            this.CFG_healthy_xp_amount = builder.comment("XP points awarded when satisfying the Healthy craving. (Default: 3)").defineInRange("Healthy XP Amount", 3, 0, Integer.MAX_VALUE);
            this.CFG_healthy_saturation_amount = builder.comment("Extra saturation points gained when satisfying the Healthy craving. (Default: 1)").defineInRange("Healthy Saturation Amount", 1.0, 0.0, 20.0);
            this.CFG_healthy_haste_level = builder.comment("Haste effect level applied when satisfying the Healthy craving. (Default: 1)").defineInRange("Healthy Haste Level", 1, 1, 255);
            this.CFG_healthy_haste_duration = builder.comment("Duration (in ticks) of the Haste effect when satisfying the Healthy craving. (Default: 6000)").defineInRange("Healthy Haste Duration", 6000, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Meaty Craving Settings");
            this.CFG_meaty_xp_amount = builder.comment("XP points awarded when satisfying the Meaty craving. (Default: 3)").defineInRange("Meaty XP Amount", 3, 0, Integer.MAX_VALUE);
            this.CFG_meaty_saturation_amount = builder.comment("Extra saturation points gained when satisfying the Meaty craving. (Default: 1)").defineInRange("Meaty Saturation Amount", 1.0, 0.0, 20.0);
            this.CFG_meaty_strength_level = builder.comment("Strength effect level applied when satisfying the Meaty craving. (Default: 1)").defineInRange("Meaty Strength Level", 1, 1, 255);
            this.CFG_meaty_strength_duration = builder.comment("Duration (in ticks) of the Strength effect when satisfying the Meaty craving. (Default: 6000)").defineInRange("Meaty Strength Duration", 6000, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Fishy Craving Settings");
            this.CFG_fishy_xp_amount = builder.comment("XP points awarded when satisfying the Fishy craving. (Default: 5)").defineInRange("Fishy XP Amount", 5, 0, Integer.MAX_VALUE);
            this.CFG_fishy_saturation_amount = builder.comment("Extra saturation points gained when satisfying the Fishy craving. (Default: 1)").defineInRange("Fishy Saturation Amount", 1.0, 0.0, 20.0);
            this.CFG_fishy_wbreathing_duration = builder.comment("Duration (in ticks) of the Water Breathing effect when satisfying the Fishy craving. (Default: 6000)").defineInRange("Fishy Water Breathing Duration", 6000, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Gross Craving Settings");
            this.CFG_gross_xp_amount = builder.comment("XP points awarded when satisfying the gross craving. (Default: 5)").defineInRange("Gross XP Amount", 5, 0, Integer.MAX_VALUE);
            this.CFG_gross_saturation_amount = builder.comment("Extra saturation points gained when satisfying the Gross craving. (Default: 0.5)").defineInRange("Gross Saturation Amount", 0.5, 0.0, 20.0);
            this.CFG_gross_resistance_level = builder.comment("Resistance effect level applied when satisfying the Gross craving. (Default: 1)").defineInRange("Gross Resistance Level", 1, 1, 255);
            this.CFG_gross_resistance_duration = builder.comment("Duration (in ticks) of the Resistance effect when satisfying the Gross craving. (Default: 6000)").defineInRange("Gross Resistance Duration", 6000, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Fancy Craving Settings");
            this.CFG_fancy_xp_amount = builder.comment("XP points awarded when satisfying the Fancy craving. (Default: 8)").defineInRange("Fancy XP Amount", 8, 0, Integer.MAX_VALUE);
            this.CFG_fancy_saturation_amount = builder.comment("Extra saturation points gained when satisfying the Fancy craving. (Default: 1)").defineInRange("Fancy Saturation Amount", 1.0, 0.0, 20.0);
            this.CFG_fancy_nvision_duration = builder.comment("Duration (in ticks) of the Night Vision effect when satisfying the Fancy craving. (Default: 6000)").defineInRange("Fancy Night Vision Duration", 6000, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Hearty Craving Settings");
            this.CFG_hearty_xp_amount = builder.comment("XP points awarded when satisfying the Hearty craving. (Default: 8)").defineInRange("Hearty XP Amount", 8, 0, Integer.MAX_VALUE);
            this.CFG_hearty_saturation_amount = builder.comment("Extra saturation points gained when satisfying the Hearty craving. (Default: 1.5)").defineInRange("Hearty Saturation Amount", 1.5, 0.0, 20.0);
            this.CFG_hearty_hboost_level = builder.comment("Health boost effect level applied when satisfying the Hearty craving. (Default: 1)").defineInRange("Hearty Health Boost Level", 1, 1, 255);
            this.CFG_hearty_hboost_duration = builder.comment("Duration (in ticks) of the Health Boost effect when satisfying the Hearty craving. (Default: 6000)").defineInRange("Hearty Health Boost Duration", 6000, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Raw Craving Settings");
            this.CFG_raw_xp_amount = builder.comment("XP points awarded when satisfying the Raw craving. (Default: 10)").defineInRange("Raw XP Amount", 10, 0, Integer.MAX_VALUE);
            this.CFG_raw_saturation_amount = builder.comment("Extra saturation points gained when satisfying the Raw craving. (Default: 0.5)").defineInRange("Raw Saturation Amount", 0.5, 0.0, 20.0);
            this.CFG_raw_nausea_duration = builder.comment("Duration (in ticks) of the Nausea effect when satisfying the Raw craving. (Default: 600)").defineInRange("Raw Nausea Duration", 600, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Consequences Settings");
            this.CFG_saturation_loss = builder.comment("Set the amount of saturation lost when missing any craving. (default = 1.5)").defineInRange("Saturation Loss", 1.5, 0.0, 20.0);
            this.CFG_hunger_level = builder.comment("Sets the amplifier (level) of the Hunger effect given when missing a craving. (default = 1)").defineInRange("Hunger level", 1, 1, 255);
            this.CFG_hunger_duration = builder.comment("Sets the duration in ticks of the Hunger effect given when missing any craving.").comment("Set to 0 to disable this effect. (default = 300)").defineInRange("Hunger duration", 300, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Sweet Consequences");
            this.CFG_slowness_level = builder.comment("Level of Slowness given by missing a Sweet craving. (default = 1)").defineInRange("Slowness Level", 1, 1, 255);
            this.CFG_slowness_duration = builder.comment("Duration in ticks of Slowness given by missing a Sweet craving. (default = 1200)").defineInRange("Slowness duration", 1200, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Healthy Consequences");
            this.CFG_mining_fatigue_level = builder.comment("Level of Mining Fatigue given by missing a Healthy craving. (default = 1)").defineInRange("Mining Fatigue Level", 1, 1, 255);
            this.CFG_mining_fatigue_duration = builder.comment("Duration in ticks of Mining Fatigue given by missing a Healthy craving. (default = 1200)").defineInRange("Mining Fatigue duration", 1200, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Meaty Consequences");
            this.CFG_weakness_level = builder.comment("Level of Weakness given by missing a Meaty craving. (default = 1)").defineInRange("Weakness Level", 1, 1, 255);
            this.CFG_weakness_duration = builder.comment("Duration in ticks of Weakness given by missing a Meaty craving. (default = 1200)").defineInRange("Weakness duration", 1200, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Fishy and Gross Consequences");
            this.CFG_nausea_duration = builder.comment("Duration in ticks of Nausea given by missing a Fishy or Gross craving. (default = 400)").defineInRange("Nausea duration", 400, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Fancy Consequences");
            this.CFG_blindness_duration = builder.comment("Duration in ticks of Blindness given by missing a Fancy craving. (default = 400)").defineInRange("Blindness duration", 400, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Hearty Consequences");
            this.CFG_hunger_hearty_level = builder.comment("Level of Hunger given by missing a Hearty craving. (default = 1)").defineInRange("Hearty Hunger Level", 1, 1, 255);
            this.CFG_hunger_hearty_duration = builder.comment("Duration in ticks of Hunger given by missing a Hearty craving.").comment("This overwrites the general Hunger effect. (default = 900)").defineInRange("Hearty Hunger duration", 900, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Raw Consequences");
            this.CFG_luck_level = builder.comment("Level of Luck given by missing a Raw craving. (default = 1)").defineInRange("Luck Level", 1, 1, 255);
            this.CFG_luck_duration = builder.comment("Duration in ticks of Luck given by missing a Raw craving. (default = 1200)").defineInRange("Luck duration", 1200, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

