/*
 * Decompiled with CFR 0.152.
 */
package net.dyrohc.cravings;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="cravings", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigFileFoods {
    public static final ForgeConfigSpec SERVER_CONFIG;
    public static final Server SERVER;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            ConfigFileFoods.apply();
        }
    }

    @SubscribeEvent
    public static void onReloading(ModConfigEvent.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            ConfigFileFoods.apply();
        }
    }

    public static void apply() {
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        SERVER = new Server(builder);
        SERVER_CONFIG = builder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG, "Cravings/cravings-foods.toml");
    }

    public static class Server {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_sweet_foods;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_healthy_foods;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_meaty_foods;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_fishy_foods;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_gross_foods;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_fancy_foods;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_hearty_foods;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_raw_foods;
        public final ForgeConfigSpec.BooleanValue CFG_FD_toggle;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_FD_sweet_foods;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_FD_healthy_foods;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_FD_meaty_foods;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_FD_fishy_foods;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_FD_gross_foods;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_FD_fancy_foods;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_FD_hearty_foods;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_FD_raw_foods;

        Server(ForgeConfigSpec.Builder builder) {
            builder.push("Cravings Foods");
            this.CFG_sweet_foods = builder.comment("Food items that satisfy your sweet craving.").defineListAllowEmpty("Sweet Foods", List.of("minecraft:cookie", "minecraft:glow_berries", "minecraft:honey_bottle", "minecraft:sweet_berries", "minecraft:melon_slice", "minecraft:chorus_fruit", "minecraft:apple", "minecraft:golden_apple", "minecraft:enchanted_golden_apple", "minecraft:pumpkin_pie", "minecraft:cake"), obj -> obj instanceof String);
            this.CFG_healthy_foods = builder.comment("Food items that satisfy your healthy craving.").defineListAllowEmpty("Healthy Foods", List.of("minecraft:potato", "minecraft:carrot", "minecraft:beetroot", "minecraft:beetroot_soup", "minecraft:baked_potato", "minecraft:golden_carrot", "minecraft:dried_kelp"), obj -> obj instanceof String);
            this.CFG_meaty_foods = builder.comment("Food items that satisfy your meaty craving.").defineListAllowEmpty("Meaty Foods", List.of("minecraft:rabbit_stew", "minecraft:cooked_rabbit", "minecraft:cooked_chicken", "minecraft:cooked_beef", "minecraft:cooked_porkchop", "minecraft:cooked_mutton"), obj -> obj instanceof String);
            this.CFG_fishy_foods = builder.comment("Food items that satisfy your fishy craving.").defineListAllowEmpty("Fishy Foods", List.of("minecraft:cooked_cod", "minecraft:cooked_salmon", "minecraft:pufferfish"), obj -> obj instanceof String);
            this.CFG_gross_foods = builder.comment("Food items that satisfy your gross craving.").defineListAllowEmpty("Gross Foods", List.of("minecraft:rotten_flesh", "minecraft:spider_eye", "minecraft:suspicious_stew", "minecraft:poisonous_potato", "minecraft:pufferfish"), obj -> obj instanceof String);
            this.CFG_fancy_foods = builder.comment("Food items that satisfy your fancy craving.").defineListAllowEmpty("Fancy Foods", List.of("minecraft:golden_apple", "minecraft:enchanted_golden_apple", "minecraft:golden_carrot", "minecraft:glow_berries"), obj -> obj instanceof String);
            this.CFG_hearty_foods = builder.comment("Food items that satisfy your hearty craving.").defineListAllowEmpty("Hearty Foods", List.of("minecraft:pumpkin_pie", "minecraft:rabbit_stew", "minecraft:mushroom_stew", "minecraft:beetroot_soup"), obj -> obj instanceof String);
            this.CFG_raw_foods = builder.comment("Food items that satisfy your raw craving.").defineListAllowEmpty("Raw Foods", List.of("minecraft:cod", "minecraft:salmon", "minecraft:rabbit", "minecraft:porkchop", "minecraft:mutton", "minecraft:chicken", "minecraft:beef"), obj -> obj instanceof String);
            builder.pop();
            builder.push("Farmer's delight Compat");
            this.CFG_FD_toggle = builder.comment("Enable Farmer's Delight foods satisfying cravings out of the box. Will only work if Farmer's Delight is installed. (Default: true)").define("Farmer's Delight Compatibility", true);
            this.CFG_FD_sweet_foods = builder.comment("Farmer's Delight food items that satisfy your sweet craving.").defineListAllowEmpty("Sweet Foods", List.of("farmersdelight:honey_glazed_ham", "farmersdelight:apple_pie", "farmersdelight:apple_pie_slice", "farmersdelight:sweet_berry_cheesecake", "farmersdelight:sweet_berry_cheesecake_slice", "farmersdelight:chocolate_pie", "farmersdelight:chocolate_pie_slice", "farmersdelight:cake_slice", "farmersdelight:honey_cookie", "farmersdelight:sweet_berry_cookie", "farmersdelight:glow_berry_custard", "farmersdelight:melon_popsicle", "farmersdelight:hot_cocoa", "farmersdelight:apple_cider", "farmersdelight:melon_juice", "farmersdelight:fruit_salad", "farmersdelight:tomato_sauce", "farmersdelight:pumpkin_slice"), obj -> obj instanceof String);
            this.CFG_FD_healthy_foods = builder.comment("Farmer's Delight food items that satisfy your healthy craving.").defineListAllowEmpty("Healthy Foods", List.of("farmersdelight:cabbage", "farmersdelight:cabbage_leaf", "farmersdelight:onion", "farmersdelight:tomato", "farmersdelight:dumplings", "farmersdelight:cabbage_rolls", "farmersdelight:kelp_roll", "farmersdelight:kelp_roll_slice", "farmersdelight:mixed_salad", "farmersdelight:vegetable_soup", "farmersdelight:vegetable_noodles", "farmersdelight:ratatouille", "farmersdelight:cooked_rice", "farmersdelight:fried_egg", "farmersdelight:fried_rice"), obj -> obj instanceof String);
            this.CFG_FD_meaty_foods = builder.comment("Farmer's Delight food items that satisfy your meaty craving.").defineListAllowEmpty("Meaty Foods", List.of("farmersdelight:barbecue_stick", "farmersdelight:chicken_sandwich", "farmersdelight:hamburger", "farmersdelight:bacon_sandwich", "farmersdelight:mutton_wrap", "farmersdelight:roast_chicken", "farmersdelight:honey_glazed_ham", "farmersdelight:shepherds_pie", "farmersdelight:beef_stew", "farmersdelight:chicken_soup", "farmersdelight:bacon_and_eggs", "farmersdelight:roasted_mutton_chops", "farmersdelight:steak_and_potatoes", "farmersdelight:beef_patty", "farmersdelight:cooked_chicken_cuts", "farmersdelight:cooked_bacon", "farmersdelight:cooked_mutton_chops", "farmersdelight:smoked_ham"), obj -> obj instanceof String);
            this.CFG_FD_fishy_foods = builder.comment("Farmer's Delight food items that satisfy your fishy craving.").defineListAllowEmpty("Fishy Foods", List.of("farmersdelight:salmon_roll", "farmersdelight:cod_roll", "farmersdelight:fish_stew", "farmersdelight:baked_cod_stew", "farmersdelight:squid_ink_pasta", "farmersdelight:grilled_salmon", "farmersdelight:cooked_cod_slice", "farmersdelight:cooked_salmon_slice"), obj -> obj instanceof String);
            this.CFG_FD_gross_foods = builder.comment("Farmer's Delight food items that satisfy your gross craving.").defineListAllowEmpty("Gross Foods", List.of("farmersdelight:dog_food", "farmersdelight:nether_salad", "farmersdelight:bone_broth"), obj -> obj instanceof String);
            this.CFG_FD_fancy_foods = builder.comment("Farmer's Delight food items that satisfy your fancy craving.").defineListAllowEmpty("Fancy Foods", List.of("farmersdelight:glow_berry_custard"), obj -> obj instanceof String);
            this.CFG_FD_hearty_foods = builder.comment("Farmer's Delight food items that satisfy your hearty craving.").defineListAllowEmpty("Hearty Foods", List.of("farmersdelight:stuffed_pumpkin", "farmersdelight:honey_glazed_ham", "farmersdelight:shepherds_pie", "farmersdelight:roast_chicken", "farmersdelight:beef_stew", "farmersdelight:chicken_soup", "farmersdelight:pumpkin_soup", "farmersdelight:baked_cod_stew", "farmersdelight:noodle_soup", "farmersdelight:bacon_and_eggs", "farmersdelight:pasta_with_meatballs", "farmersdelight:pasta_with_mutton_chop", "farmersdelight:mushroom_rice", "farmersdelight:roasted_mutton_chops", "farmersdelight:steak_and_potatoes", "farmersdelight:ratatouille", "farmersdelight:squid_ink_pasta", "farmersdelight:grilled_salmon", "farmersdelight:fried_rice", "farmersdelight:fish_stew"), obj -> obj instanceof String);
            this.CFG_FD_raw_foods = builder.comment("Farmer's Delight food items that satisfy your raw craving.").defineListAllowEmpty("Raw Foods", List.of("farmersdelight:minced_beef", "farmersdelight:chicken_cuts", "farmersdelight:bacon", "farmersdelight:cod_slice", "farmersdelight:salmon_slice", "farmersdelight:mutton_chops", "farmersdelight:ham"), obj -> obj instanceof String);
            builder.pop();
        }
    }
}

